<?php
/**
 * The create view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

formPanel
(
    on::click('.add-item', 'window.addItem'),
    on::click('.delete-item', 'window.removeItem'),
    on::change('[name^=products]', 'window.loadRelease'),
    setID('createPanel'),
    set::title($lang->deploy->create),
    formGroup
    (
        set::className('items-center'),
        set::label($lang->deploy->name),
        set::name('name'),
        set::required(true)
    ),
    formGroup(set::className('items-center'), set::name('desc'), set::label($lang->deploy->desc), set::control('editor'), set::rows(10)),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->deploy->owner),
        set::required(true),
        picker
        (
            set::name('owner'),
            set::items($users)
        )
    ),
    formRow
    (
        formGroup
        (
            set::label($lang->deploy->lblBeginEnd),
            set::required(true),
            inputGroup
            (
                datetimePicker
                (
                    set::name('begin'),
                    set::placeholder($lang->deploy->begin)
                ),
                span
                (
                    '~',
                    set::className('input-group-addon')
                ),
                datetimePicker
                (
                    set::name('end'),
                    set::placeholder($lang->deploy->end)
                )
            )
        )
    ),
    formGroup
    (
        set::label($lang->deploy->members),
        picker
        (
            set::name('members[]'),
            set::items($users),
            set::multiple(true)
        )
    ),
    formRow
    (
        set::className('flex-wrap'),
        formGroup
        (
            set::label($lang->deploy->lblProduct),
            set::className('product-box w-full'),
            inputGroup
            (
                $lang->deploy->product,
                picker(set::name('products[]'), set::items($products), set::value($product), set::className('linkProduct')),
                span
                (
                    $lang->deploy->release,
                    set::className('input-group-addon')
                ),
                picker
                (
                    set::name('release[]'),
                    set::className('releases'),
                    set::items($releases)
                ),
                span
                (
                    $lang->deploy->package,
                    set::className('input-group-addon')
                ),
                input(set::name('package[]')),
                div
                (
                    set::className('c-action first-action flex'),
                    span
                    (
                        setClass('input-group-addon'),
                        h::a
                        (
                            setClass('add-item'),
                            set::href('javascript:void(0)'),
                            icon('plus')
                        )
                    ),
                    span
                    (
                        setClass('input-group-addon'),
                        a
                        (
                            setClass('delete-item'),
                            set::href('javascript:void(0)'),
                            icon('close')
                        )
                    )
                )
            )
        )
    )
);

render();
