window.getCol = function(col)
{
    if(col.cards) col.subtitle = {html: "<span class='text-gray ml-1'>" + col.cards + "</span>"};
}

window.itemRender = function(info)
{
    info.item.title = info.item.col == 'cases' ? info.item.title : info.item.begin.substr(11, 5) + '~' + info.item.end.substr(11, 5) + ' ' + info.item.title;
    info.item.titleUrl = canViewStep ? $.createLink('deploy', 'viewStep', `id=${info.item.id}`) : '';

    let content;
    if(info.item.col != 'cases')
    {
        info.item.titleUrl   = canViewStep ? $.createLink('deploy', 'viewStep', `id=${info.item.id}`) : '';

        assignedToUrl = $.createLink('deploy', 'assignTo', `id=${info.item.id}`);
        finishUrl = $.createLink('deploy', 'FinishStep', `id=${info.item.id}`);

        content = `
        <div>${info.item.content}</div>
        <div class='flex items-center justify-between'>
          <a class='text-gray mr-1' href=${assignedToUrl} data-toggle='modal'>
             <i class='icon icon-hand-right mr-1'></i>
             ${info.item.assignedTo}
          </a>`
        if(info.item.status != 'done')
        {
            info.item.innerClass = 'bg-gray bg-opacity-20';
            content += ` <a  class='date ml-1 right' href=${finishUrl} data-toggle='modal'> ` + deployLang.finish + `</a>`
        }
        else
        {
            info.item.innerClass = 'bg-success bg-opacity-20';
            content += ` <span class='date ml-1 right'><i class='icon icon-info mr-1'></i>` + deployLang.statusList[info.item.status] + `</span>`
        }
        content += `</div>`
    }
    else
    {
        info.item.innerClass = 'bg-important bg-opacity-30';
        info.item.titleUrl = canViewCase ? $.createLink('testcase', 'view', `id=${info.item.id}`) : '';
        if(caseResults[info.item.id])
        {
            content = `
            <div class='flex items-center justify-between'>
            <span class='case-lastRunner' title='` + testcaseLang.lastRunner + `'>
            <i class='icon icon-person mr-1'></i> ` + users[caseResults[info.item.id].lastRunner] + `</span>`

            if(canViewCaseRunResult)
            {
                const deployCaseResultURL = $.createLink('testtask', 'results', `runID=0&caseID=${info.item.id}&version=${info.item.version}&status=done&type=all&deployID=` + deployID);
                content += `
                <a class='text-gray mr-1' href=${deployCaseResultURL} data-toggle='modal'>
                <i class='icon icon-stack mr-1'></i>
                ` + testcaseLang.resultList[caseResults[info.item.id].caseResult] + `</a>`

            }
            content += `</div>`
        }
    }

    info.item.titleAttrs = {'class': 'card-title clip', 'title' : info.item.title, 'data-toggle': 'modal', 'data-size': 'lg'};
    info.item.content = {html: content};
}

window.getItem = function(info)
{
    if(info.item.col == 'cases')
    {
        info.item.titleAttrs = {'class': 'text-black clip', 'title' : info.item.title, 'data-toggle': 'modal'};
    }
    else
    {
        info.item.titleAttrs = {'class': 'text-black clip', 'title' : info.item.begin.substr(11, 5) + '~' + info.item.end.substr(11, 5) + info.item.title, 'data-toggle': 'modal'};
    }
}

window.getItemActions = function(item)
{
    if(!canModify) return [];

    if(item.col == 'cases')
    {
        if(! canRunCase) return [];

        return [{
            type: 'btn',
            text: testtaskLang.runCase,
            className: 'btn size-sm ghost',
            url: $.createLink('testtask', 'runCase', `runID=0&caseID=${item.id}&version=${item.version}`),
            'data-toggle': 'modal',
            'data-size': 'lg'
        }];
    }

    return [{
        type: 'dropdown',
        icon: 'ellipsis-v',
        caret: false,
        items: buildCardActions(item),
    }];
}

window.buildCardActions = function(item)
{
    let actions = [];

    if(canFinish && item.status != 'done' ) actions.push({text: deployLang.finish, url: $.createLink('deploy', 'FinishStep', `id=${item.id}`), 'data-toggle': 'modal'});
    if(canAssignTo) actions.push({text: deployLang.assignTo, url: $.createLink('deploy', 'assignTo', `id=${item.id}`), 'data-toggle': 'modal'});
    if(canEdit) actions.push({text: deployLang.edit, url: $.createLink('deploy', 'editStep', `id=${item.id}`), 'data-toggle': 'modal'});
    if(canDelete) actions.push({text: deployLang.delete, url: $.createLink('deploy', 'deleteStep', `id=${item.id}`), 'innerClass': 'ajax-submit', 'data-confirm' : deployLang.confirmDeleteStep});
    return actions;
}

window.canDrop = function(dragInfo, dropInfo)
{
    return false;
}
