<?php
namespace zin;
global $lang;

$fields = defineFieldList('issue');

$fields->field('title')
    ->width('full')
    ->control('input')
    ->value(data('issue.title'));

$fields->field('type')
    ->control('picker')
    ->items($lang->issue->typeList)
    ->value(data('issue.type'));

$fields->field('risk')
    ->control('picker')
    ->items(data('risks'))
    ->value(data('issue.risk'));

$fields->field('execution')
    ->control('picker')
    ->items(data('executions'))
    ->value(data('issue.execution'));

$fields->field('severity')
    ->width('1/4')
    ->control('severityPicker', array('required' => true))
    ->items($lang->issue->severityList)
    ->value(data('issue.severity'));

$fields->field('pri')
    ->width('1/4')
    ->control('priPicker', array('required' => true))
    ->items($lang->issue->priList)
    ->value(data('issue.pri'));

$fields->field('assignedTo')
    ->width('1/4')
    ->control('picker')
    ->items(data('teamMembers'))
    ->value(data('issue.assignedTo'));

$fields->field('owner')
    ->width('1/4')
    ->control('picker')
    ->items(data('teamMembers'))
    ->value(data('issue.owner'));

$fields->field('deadline')
    ->control('datePicker')
    ->value(data('issue.deadline'));

$fields->field('desc')
    ->width('full')
    ->control('editor')
    ->value(data('issue.desc'));

$fields->field('files')
    ->width('full')
    ->control('fileSelector');
