<?php
/**
 * The managescope view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;
foreach($scope as &$item)
{
    $service      = zget($services, $item->service, array());
    $serviceHosts = zget($service, 'hosts') . ',' . $item->hosts;
    $hostPairs    = array();
    if($serviceHosts)
    {
        foreach(explode(',', $serviceHosts) as $hostID)
        {
            if(!isset($hosts[$hostID])) continue;
            $hostPairs[$hostID] = $hosts[$hostID];
        }
    }
    $item->hostPairs = $hostPairs;
}

formBatchPanel
(
    on::change('[data-name="service"]', 'loadHost'),
    set::onRenderRow(jsRaw('renderRowData')),
    set::title($object->name . $lang->hyphen . $lang->deploy->manageScope),
    set::data(array_values($scope)),
    formBatchItem
    (
        set::name('id'),
        set::label($lang->idAB),
        set::control('hidden'),
        set::hidden(true)
    ),
    formBatchItem
    (
        set::name('service'),
        set::label($lang->deploy->service),
        set::control('picker'),
        set::items($optionMenu)
    ),
    formBatchItem
    (
        set::name('hosts'),
        set::label($lang->deploy->hadHost),
        set::control('picker'),
        set::multiple(true),
        set::items($hosts)
    ),
    formBatchItem
    (
        set::name('remove'),
        set::label($lang->deploy->removeHost),
        set::control('picker'),
        set::multiple(true),
        set::items($hosts)
    ),
    formBatchItem
    (
        set::name('add'),
        set::label($lang->deploy->addHost),
        set::control('picker'),
        set::multiple(true),
        set::items($hosts)
    )
);
