window.onChangeStoreAppType = function(event)
{
    let storeApp = appID;
    if(!storeApp)
    {
        if(typeof(event) == 'undefined')
        {
            storeApp = defaultApp;
        }
        else
        {
            storeApp = $('[name=storeAppType]').val();
        }
    }

    $('#createStoreAppForm').data('appid', storeApp);
    $('#createStoreAppForm').attr('action', $.createLink('instance', 'install', 'appID=' + storeApp));

    var storeAppName = apps[storeApp];

    if(externalApps.indexOf(storeAppName) !== -1)
    {
        $('#createStoreAppForm input[name=type][value=external]').prop('disabled', false);
    }
    else
    {
        $('#createStoreAppForm input[name=type][value=external]').prop('disabled', true);
    }

    toggleLoading('#app_version', true);
    toggleLoading('#dbService', true);
    if(storeApp)
    {
        $.getJSON($.createLink('space', 'getStoreAppInfo', 'appID=' + storeApp), function(app)
        {
            $('#app_version').val(app.app_version);
            if(showVersion === true)
            {
                $('#version').picker({items: app.versionList, name: 'version', required: true});
                setTimeout(() =>
                {
                    $('#version').picker('setValue', app.versionList[0].value);
                }, 300);
            }
            else
            {
                $('#version').val(app.version);
            }
            if((app.dependencies.mysql && mysqlList) || (app.dependencies.postgresql && pgList && pgList.length > 0))
            {
                $('div.dbType').removeClass('hidden');
                $('[name=dbService]').prop('disabled', false);

                var dbServiceItems = [];
                var dbService = (app.dependencies.mysql && mysqlList) ? mysqlList : pgList;
                for(i in dbService)
                {
                    dbServiceItems.push({'text': dbService[i].alias, 'value': dbService[i].name});
                }
                $('#dbService').zui('picker').render({items: dbServiceItems});
            }
            else
            {
                $('div.dbType').addClass('hidden');
                $('[name=dbService]').prop('disabled', true);
            }

            toggleLoading('#app_version', false);
            toggleLoading('#dbService', false);

            $('#createStoreAppForm .form-row-group').hide();
            $('#createStoreAppForm .custom-field-row').remove();
            if(app.custom_settings)
            {
                $('#createStoreAppForm .form-row-group').show();
                app.custom_settings.forEach((setting) =>
                {
                    if($('#createStoreAppForm .form-row').find('input[name=' + setting.name + ']').length) return ;
                    const $formRow = $('#customField .form-row').clone();
                    $formRow.find('label').find('span').text(setting.label);
                    $formRow.find('input').attr('name', setting.name).attr('type', setting.type).attr('autocomplete', 'new-password').attr('placeholder', setting.desc).val(setting.default);
                    if(setting.required) $formRow.find('.form-label').addClass('required');

                    $('#createStoreAppForm .form-row').last().before($formRow);
                });
            }
        });
    }
}
