<?php
/**
 * The manage view file of service module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     service
 * @link        https://www.zentao.net
 */
namespace zin;

h::script('var jQuery  = $;');
h::importCss($app->getWebRoot() . 'theme/zui/treemap/min.css');
h::importJs($app->getWebRoot() . 'js/zui/treemap/min.js');

featureBar();
toolbar
(
    btnGroup
    (
        btn
        (
            setClass('btn primary'),
            set::url(createLink('service', 'browse')),
            set::icon('program'),
            $lang->service->listView
        ),
        hasPriv('service', 'create') ? btn
        (
            setClass('btn primary ml-2'),
            set::icon('plus'),
            set::url(createLink('service', 'create')),
            $lang->service->createTop
        ) : null
    )
);

$groups = array();
foreach($topServices as $id => $topService)
{
    $group = new stdclass();
    $group->id     = $id;
    $group->name   = $topService;
    $group->parent = 0;
    $group->url    = inLink('manage', "serviceID={$id}");
    $groups[] = $group;
}
sidebar
(
    moduleMenu(set(array(
        'modules'     => $groups,
        'activeKey'   => $serviceID,
        'allText'     => $lang->service->all,
        'showDisplay' => false,
        'closeLink'   => $this->createLink('service', 'manage')
    )))
);

$canCreate = hasPriv('service', 'create');
$canView   = hasPriv('service', 'view');
$canEdit   = hasPriv('service', 'edit');
$canDelete = hasPriv('service', 'delete');

$onTreemapContextmenu = <<<JS
function(options)
{
    const node  = options.node;
    const items = [];
    if($canCreate && node.row < 2) {
        items.push({text: '{$lang->service->createDepend}', 'data-toggle': 'modal', 'url': $.createLink('service', 'create', `serviceID=\${node.serviceID}`)});
    }

    if($canCreate) items.push({text: '{$lang->service->createPeer}', 'data-toggle': 'modal', 'url': $.createLink('service', 'create', `serviceID=\${node.parentID}`)});
    if($canView)   items.push({text: '{$lang->service->detail}', 'data-toggle': 'modal', 'url': $.createLink('service', 'view', `serviceID=\${node.serviceID}`)});
    if($canEdit)   items.push({text: '{$lang->edit}', 'data-toggle': 'modal', 'url': $.createLink('service', 'edit', `serviceID=\${node.serviceID}`)});
    if($canDelete) items.push({text: '{$lang->delete}', 'data-confirm': '{$lang->service->confirmDelete}', 'innerClass': 'ajax-submit', 'url': $.createLink('service', 'delete', `serviceID=\${node.serviceID}`)});

    return {items: items};
}
JS;

treemap
(
    setClass('canvas'),
    set::data($tree),
    set::height('450px'),
    set::onNodeClick(jsRaw('(node) => window.onTreemapNodeClick(node)')),
    set::onContextMenu(jsRaw($onTreemapContextmenu))
);
