/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LeafValue;

public class StringValue
implements Expression,
LeafValue {
    private String value = "";

    public StringValue(String escapedValue) {
        this.value = escapedValue.substring(1, escapedValue.length() - 1);
    }

    public String getValue() {
        return this.value;
    }

    public String getNotExcapedValue() {
        StringBuffer buffer = new StringBuffer(this.value);
        int index = 0;
        int deletesNum = 0;
        while ((index = this.value.indexOf("''", index)) != -1) {
            buffer.deleteCharAt(index - deletesNum);
            index += 2;
            ++deletesNum;
        }
        return buffer.toString();
    }

    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "'" + this.value + "'";
    }

    @Override
    public long toLong() throws LeafValue.InvalidLeaf {
        throw new LeafValue.InvalidLeaf();
    }

    @Override
    public double toDouble() throws LeafValue.InvalidLeaf {
        throw new LeafValue.InvalidLeaf();
    }

    public boolean equals(Object o) {
        try {
            return this.value.equals(((StringValue)o).value);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

