/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LeafValue;

public class LongValue
implements Expression,
LeafValue {
    private long value;

    public LongValue(long value) {
        this.value = value;
    }

    public LongValue(String value) {
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        this.value = Long.parseLong(value);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long d) {
        this.value = d;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public long toLong() {
        return this.getValue();
    }

    @Override
    public double toDouble() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleValue) {
            return (double)this.value == ((DoubleValue)o).getValue();
        }
        if (o instanceof LongValue) {
            return this.value == ((LongValue)o).getValue();
        }
        return false;
    }
}

