/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LeafValue;
import net.sf.jsqlparser.expression.LongValue;

public class DoubleValue
implements Expression,
LeafValue {
    private double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    public DoubleValue(String value) {
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        this.value = Double.parseDouble(value);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public long toLong() throws LeafValue.InvalidLeaf {
        throw new LeafValue.InvalidLeaf();
    }

    @Override
    public double toDouble() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleValue) {
            return this.value == ((DoubleValue)o).getValue();
        }
        if (o instanceof LongValue) {
            return this.value == (double)((LongValue)o).getValue();
        }
        return false;
    }
}

