# Generated by Django 3.2.6 on 2022-01-04 20:58

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import martor.models
import simple_history.models
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('taggit', '0003_taggeditem_add_unique_index'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('body', martor.models.MartorField()),
                ('accepted', models.BooleanField(default=False)),
                ('a_reputation', models.IntegerField(default=0)),
                ('is_bountied_awarded', models.BooleanField(default=False)),
                ('active_time', models.DateTimeField(auto_now=True)),
                ('a_edited_time', models.DateTimeField(auto_now=True)),
                ('why_editing', models.CharField(default='', max_length=5000)),
                ('deletedHistory', models.CharField(choices=[('DELETED', 'Deleted'), ('UNDELETED', 'UnDeleted')], default='', max_length=5000)),
                ('monitor_it', models.BooleanField(default=False)),
                ('why_editing_answer', models.CharField(blank=True, default='', max_length=5000, null=True)),
                ('revival_stage_one', models.BooleanField(blank=True, default=False, null=True)),
                ('necromancer_check', models.BooleanField(blank=True, default=False, null=True)),
                ('is_wiki_answer', models.BooleanField(default=False)),
                ('is_deleted', models.BooleanField(default=False)),
                ('deleted_time', models.DateTimeField(auto_now_add=True)),
                ('a_edited_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='a_edited_time', to=settings.AUTH_USER_MODEL)),
                ('a_vote_downs', models.ManyToManyField(blank=True, related_name='a_vote_down', to=settings.AUTH_USER_MODEL)),
                ('a_vote_ups', models.ManyToManyField(blank=True, related_name='a_vote_up', to=settings.AUTH_USER_MODEL)),
                ('answer_owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Bounty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bounty_value', models.CharField(choices=[('50', '50'), ('100', '100'), ('150', '150'), ('200', '200'), ('250', '250'), ('300', '300'), ('350', '350'), ('400', '400'), ('450', '450'), ('500', '500')], default='50', max_length=500)),
                ('why_bounting', models.CharField(default='', max_length=30)),
                ('is_awarded', models.BooleanField(default=False)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('bounty_awarded_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bounty_awarded_to', to=settings.AUTH_USER_MODEL)),
                ('by_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='CommentQ',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False)),
                ('comment', models.CharField(default='', max_length=200)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('com_upvote_time', models.DateTimeField(auto_now_add=True)),
                ('answer_comment', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='qa.answer')),
                ('com_upvote', models.ManyToManyField(blank=True, related_name='comm_upvote', to=settings.AUTH_USER_MODEL)),
                ('commented_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=5000)),
                ('body', martor.models.MartorField()),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('active_date', models.DateTimeField(auto_now=True)),
                ('q_reputation', models.IntegerField(default=0)),
                ('q_edited_time', models.DateTimeField(auto_now_add=True)),
                ('is_bountied', models.BooleanField(default=False)),
                ('bounty_date_announced', models.DateTimeField(auto_now_add=True)),
                ('limit_exced', models.BooleanField(default=False)),
                ('is_edited', models.BooleanField(default=False)),
                ('is_protected', models.BooleanField(default=False)),
                ('why_editing_question', models.CharField(default='', max_length=5000)),
                ('is_deleted', models.BooleanField(default=False)),
                ('answeredOnMinusTwo_Downvote', models.DateTimeField(auto_now_add=True)),
                ('is_closed', models.BooleanField(default=False)),
                ('closed_at', models.DateTimeField(auto_now_add=True)),
                ('is_answer_accepted', models.BooleanField(default=False)),
                ('reversal_monitor', models.BooleanField(default=False)),
                ('lastActiveFor', models.CharField(blank=True, choices=[('ANSWERED', 'Answered'), ('MODIFIED', 'Modified'), ('ASKED', 'Asked')], default='', max_length=5000)),
                ('slug', models.SlugField(blank=True, max_length=1000, null=True)),
                ('deleted_time', models.DateTimeField(auto_now_add=True)),
                ('lastActiveFor_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='lastActiveFor_by', to=settings.AUTH_USER_MODEL)),
                ('post_owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('q_edited_by', models.ForeignKey(blank=True, default='', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='q_edited_by', to=settings.AUTH_USER_MODEL)),
                ('tags', taggit.managers.TaggableManager(help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags')),
                ('viewers', models.ManyToManyField(blank=True, related_name='viewed_posts', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='Reputation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('inc_dec', models.CharField(choices=[('Increased', 'Increased'), ('Decreased', 'Decreased')], default='', max_length=30)),
                ('question_rep_C', models.IntegerField(blank=True, default=0, null=True)),
                ('answer_rep_C', models.IntegerField(blank=True, default=0, null=True)),
                ('reputation_on_what', models.CharField(choices=[('QUESTION', 'Question'), ('ANSWER', 'Answer'), ('EDIT', 'Edit'), ('ANSWER_ACCEPT', 'Answer Accept')], default='', max_length=30)),
                ('date_earned', models.DateTimeField(auto_now_add=True)),
                ('answer_O', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='qa.answer')),
                ('awarded_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('question_O', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='qa.question')),
            ],
        ),
        migrations.CreateModel(
            name='QUpvote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('upvote_by_q', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('upvote_question_of', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qa.question')),
            ],
        ),
        migrations.CreateModel(
            name='QDownvote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('downvote_by_q', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('downvote_question_of', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qa.question')),
            ],
        ),
        migrations.CreateModel(
            name='ProtectQuestion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('why_want_toProtect', models.CharField(default='', max_length=30)),
                ('protected_date', models.DateTimeField(auto_now_add=True)),
                ('stillProtected', models.BooleanField(default=False)),
                ('date_Removed', models.DateTimeField(blank=True, null=True)),
                ('protected_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('protecting_question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qa.question')),
                ('protectionRemovedBy', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='protectionRemovedBy', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='HistoricalQUpvote',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('date', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='qupvotehistory', to='qa.qupvote')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('upvote_by_q', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('upvote_question_of', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='qa.question')),
            ],
            options={
                'verbose_name': 'historical q upvote',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalQuestion',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=5000)),
                ('body', martor.models.MartorField()),
                ('date', models.DateTimeField(blank=True, editable=False)),
                ('active_date', models.DateTimeField(blank=True, editable=False)),
                ('q_reputation', models.IntegerField(default=0)),
                ('q_edited_time', models.DateTimeField(blank=True, editable=False)),
                ('is_bountied', models.BooleanField(default=False)),
                ('bounty_date_announced', models.DateTimeField(blank=True, editable=False)),
                ('limit_exced', models.BooleanField(default=False)),
                ('is_edited', models.BooleanField(default=False)),
                ('is_protected', models.BooleanField(default=False)),
                ('why_editing_question', models.CharField(default='', max_length=5000)),
                ('is_deleted', models.BooleanField(default=False)),
                ('answeredOnMinusTwo_Downvote', models.DateTimeField(blank=True, editable=False)),
                ('is_closed', models.BooleanField(default=False)),
                ('closed_at', models.DateTimeField(blank=True, editable=False)),
                ('is_answer_accepted', models.BooleanField(default=False)),
                ('reversal_monitor', models.BooleanField(default=False)),
                ('lastActiveFor', models.CharField(blank=True, choices=[('ANSWERED', 'Answered'), ('MODIFIED', 'Modified'), ('ASKED', 'Asked')], default='', max_length=5000)),
                ('slug', models.SlugField(blank=True, max_length=1000, null=True)),
                ('deleted_time', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='his', to='qa.question')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('lastActiveFor_by', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('post_owner', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('q_edited_by', models.ForeignKey(blank=True, db_constraint=False, default='', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical question',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalQDownvote',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('date', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('downvote_by_q', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('downvote_question_of', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='qa.question')),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='qdownvotehistory', to='qa.qdownvote')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical q downvote',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalCommentQ',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('deleted', models.BooleanField(default=False)),
                ('comment', models.CharField(default='', max_length=200)),
                ('date', models.DateTimeField(blank=True, editable=False)),
                ('com_upvote_time', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('answer_comment', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='qa.answer')),
                ('commented_by', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='commentHis', to='qa.commentq')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('question_comment', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='qa.question')),
            ],
            options={
                'verbose_name': 'historical comment q',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalBounty',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('bounty_value', models.CharField(choices=[('50', '50'), ('100', '100'), ('150', '150'), ('200', '200'), ('250', '250'), ('300', '300'), ('350', '350'), ('400', '400'), ('450', '450'), ('500', '500')], default='50', max_length=500)),
                ('why_bounting', models.CharField(default='', max_length=30)),
                ('is_awarded', models.BooleanField(default=False)),
                ('date', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('bounty_awarded_to', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('by_user', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='bountyhistory', to='qa.bounty')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('question_bounty', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='qa.question')),
            ],
            options={
                'verbose_name': 'historical bounty',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalAnswer',
            fields=[
                ('id', models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('date', models.DateTimeField(blank=True, editable=False)),
                ('body', martor.models.MartorField()),
                ('accepted', models.BooleanField(default=False)),
                ('a_reputation', models.IntegerField(default=0)),
                ('is_bountied_awarded', models.BooleanField(default=False)),
                ('active_time', models.DateTimeField(blank=True, editable=False)),
                ('a_edited_time', models.DateTimeField(blank=True, editable=False)),
                ('why_editing', models.CharField(default='', max_length=5000)),
                ('deletedHistory', models.CharField(choices=[('DELETED', 'Deleted'), ('UNDELETED', 'UnDeleted')], default='', max_length=5000)),
                ('monitor_it', models.BooleanField(default=False)),
                ('why_editing_answer', models.CharField(blank=True, default='', max_length=5000, null=True)),
                ('revival_stage_one', models.BooleanField(blank=True, default=False, null=True)),
                ('necromancer_check', models.BooleanField(blank=True, default=False, null=True)),
                ('is_wiki_answer', models.BooleanField(default=False)),
                ('is_deleted', models.BooleanField(default=False)),
                ('deleted_time', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('a_edited_by', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('answer_owner', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('history_relation', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, related_name='anshis', to='qa.answer')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('questionans', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='qa.question')),
            ],
            options={
                'verbose_name': 'historical answer',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddField(
            model_name='commentq',
            name='question_comment',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='qa.question'),
        ),
        migrations.AddField(
            model_name='bounty',
            name='question_bounty',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qa.question'),
        ),
        migrations.CreateModel(
            name='BookmarkQuestion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('bookmarked_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('bookmarked_question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qa.question')),
            ],
        ),
        migrations.CreateModel(
            name='BannedUser',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('banned_reasons', models.CharField(choices=[('DOING_SOCKPUPPETS', 'Doing SockPuppets'), ('RUDE_TO_MEMBERS', 'Rude to Members'), ('TERMS_AND_CONDITIONS_VOILATIONS', 'Terms and Conditions Voilations')], default='', max_length=50)),
                ('baned_at', models.DateTimeField(auto_now_add=True)),
                ('is_banned', models.BooleanField(default=False)),
                ('ban_till', models.CharField(choices=[('3_DAYS', '3 Days'), ('7_DAYS', '7 Days'), ('15_DAYS', '15 DAYS'), ('30_DAYS', '30 DAYS'), ('2_MONTHS', '2 MONTHS'), ('6_MONTHS', '6 MONTHS'), ('1_YEAR', '1 YEAR'), ('4_YEARS', '4 YEARS')], default='', max_length=30)),
                ('banned_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='banned_by', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='user', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='AnswerComment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tex', models.CharField(default='', max_length=30)),
                ('com', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='qa.answer')),
            ],
        ),
        migrations.AddField(
            model_name='answer',
            name='questionans',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='qa.question'),
        ),
    ]
