import React, { useState, useEffect } from "react";
import { useNavigate } from "react-router-dom";
import { v4 as uuidv4 } from "uuid";

export default function Home() {
  const [username, setUsername] = useState("");
  const navigate = useNavigate();

  useEffect(() => {
    const getQueryParam = (name) => {
      const queryString = window.location.search;
      const urlParams = new URLSearchParams(queryString);
      return urlParams.get(name);
    };

    const adminLeft = getQueryParam("adminLeft");
    if (adminLeft === "true") {
      alert("Admin has left the room");
      navigate("/");
    }
  }, [navigate]);

  const handleFormSubmit = (e) => {
    e.preventDefault();
    const clickedButtonId = e.nativeEvent.submitter.id;
    const isCreateRoom = clickedButtonId === "create-room-btn";
    const path = isCreateRoom ? "/chat" : "/join";
    const roomCode = isCreateRoom ? uuidv4() : "";
    const url = `${path}?${isCreateRoom ? `room=${roomCode}&` : ""}username=${username}`;
    navigate(url);

    if (isCreateRoom) {
      alert("Do not refresh the page, else your queue will get cleared!");
      alert("End the room only using the end room button. Closing the tab or back button won't do.");
    }
  };

  const handleUsernameChange = (e) => {
    setUsername(e.target.value);
  };

  return (
    <div
      className="flex flex-col items-center justify-center min-h-screen"
      style={{
        backgroundImage:
          "url('https://img.freepik.com/premium-photo/grainy-gradient-background-red-white-blue-colors-with-soft-faded-watercolor-border-texture_927344-24167.jpg?semt=ais_hybrid')",
        backgroundSize: "cover",
        backgroundPosition: "center",
        backgroundRepeat: "no-repeat",
      }}
    >
      <header className="mb-10">
      <h1 
  className="text-white text-6xl font-extrabold tracking-wider drop-shadow-2xl 
             animate-pulse bg-clip-text text-transparent bg-gradient-to-r from-pink-500 
             via-purple-500 to-blue-500"
  style={{
    backgroundImage: "url('https://images.unsplash.com/photo-1494959764136-6be9eb3c261e?fit=crop&w=1920&q=80')",
    backgroundSize: "cover",
    backgroundPosition: "center",
    backgroundClip: "text",
    WebkitBackgroundClip: "text",
    color: "transparent",
    textShadow: "0 1px 2px rgba(0, 0, 0, 0.8)"
  }}
>
  YTParty
</h1>

      </header>

      <main className="w-full max-w-md p-8 bg-white bg-opacity-30 backdrop-filter backdrop-blur-md rounded-lg shadow-2xl">
        <form onSubmit={handleFormSubmit} className="space-y-6">
          <div>
            <label htmlFor="username" className="sr-only">
              Username
            </label>
            <input
              type="text"
              name="username"
              id="username"
              placeholder="Enter Username..."
              value={username}
              onChange={handleUsernameChange}
              required
              className="w-full p-3 text-lg bg-white bg-opacity-40 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-300 focus:border-pink-500 transition-all duration-300"
            />
          </div>

          <div className="flex flex-col space-y-4">
            <button
              type="submit"
              className="w-full bg-pink-600 hover:bg-pink-700 text-white font-bold text-lg py-3 rounded-lg transition duration-200 ease-in-out shadow-md hover:shadow-xl transform hover:-translate-y-1"
              id="join-room-btn"
            >
              Join Chat
            </button>
            <button
              type="submit"
              className="w-full bg-purple-600 hover:bg-purple-700 text-white font-bold text-lg py-3 rounded-lg transition duration-200 ease-in-out shadow-md hover:shadow-xl transform hover:-translate-y-1"
              id="create-room-btn"
            >
              Create Room
            </button>
          </div>
        </form>
      </main>
    </div>
  );
}
