﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "11" -and ($_.message -match "TargetFilename.*.*C:\\Windows\\system32\\physmem.sys" -or $_.message -match "TargetFilename.*.*C:\\Windows\\System32\\IME\\IMEJP\\imjpueact.dll" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\IMETC\\IMTCPROT.DLL" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\SHARED\\imecpmeid.dll" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\config\\spp\\ServiceState\\Recovery\\pac.dat" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\config\\cy-GB\\Setup\\SKB\\InputMethod\\TupTask.dat" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\config\\config\\startwus.dat" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\SHARED\\WimBootConfigurations.ini" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\IMEJP\\WimBootConfigurations.ini" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\IMETC\\WimBootConfigurations.ini")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message
# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {((($_.ID -eq "12" -or $_.ID -eq "13" -or $_.ID -eq "14")) -and ($_.message -match "TargetObject.*.*\\Software\\Classes\\CLSID\\{CF4CC405-E2C5-4DDD-B3CE-5E7582D8C9FA}\\InprocServer32" -or $_.message -match "TargetObject.*.*\\SOFTWARE\\Classes\\CLSID\\{7C857801-7381-11CF-884D-00AA004B2E24}\\InProcServer32") -and $_.message -match "IMJPUEXP.DLL") } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "sysmon_cve_2021_31979_cve_2021_33771_exploits";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )

            $ruleName = "sysmon_cve_2021_31979_cve_2021_33771_exploits";
            $detectedMessage = "Detects patterns as noticed in exploitation of Windows CVE-2021-31979 CVE-2021-33771 vulnerability and DevilsTongue malware by threat group Sourgum";
            $results = [System.Collections.ArrayList] @();
            $tmp = $event | where { ($_.ID -eq "11" -and ($_.message -match "TargetFilename.*.*C:\\Windows\\system32\\physmem.sys" -or $_.message -match "TargetFilename.*.*C:\\Windows\\System32\\IME\\IMEJP\\imjpueact.dll" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\IMETC\\IMTCPROT.DLL" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\SHARED\\imecpmeid.dll" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\config\\spp\\ServiceState\\Recovery\\pac.dat" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\config\\cy-GB\\Setup\\SKB\\InputMethod\\TupTask.dat" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\config\\config\\startwus.dat" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\SHARED\\WimBootConfigurations.ini" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\IMEJP\\WimBootConfigurations.ini" -or $_.message -match "TargetFilename.*.*C:\\Windows\\system32\\ime\\IMETC\\WimBootConfigurations.ini")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            [void]$results.Add($tmp);
            $tmp = $event | where { ((($_.ID -eq "12" -or $_.ID -eq "13" -or $_.ID -eq "14")) -and ($_.message -match "TargetObject.*.*\\Software\\Classes\\CLSID\\{CF4CC405-E2C5-4DDD-B3CE-5E7582D8C9FA}\\InprocServer32" -or $_.message -match "TargetObject.*.*\\SOFTWARE\\Classes\\CLSID\\{7C857801-7381-11CF-884D-00AA004B2E24}\\InProcServer32") -and $_.message -match "IMJPUEXP.DLL") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            [void]$results.Add($tmp);
            
            foreach ($result in $results) {
                if ($result -and $result.Count -ne 0) {
                    Write-Output ""; 
                    Write-Output "Detected! RuleName:$ruleName";
                    Write-Output $detectedMessage;    
                    Write-Output $result;
                    Write-Output ""; 
                }
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
