﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "12" -or $_.ID -eq "13" -or $_.ID -eq "14") -and $_.message -match "TargetObject.*HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Ports" -and ($_.message -match "Details.*.*.dll" -or $_.message -match "Details.*.*.exe" -or $_.message -match "Details.*.*.bat" -or $_.message -match "Details.*.*.com" -or $_.message -match "Details.*.*C:")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "sysmon_cve-2020-1048";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "sysmon_cve-2020-1048";
            $detectedMessage = "Detects a new and suspicious printer port creation in Registry that could be an attempt to exploit CVE-2020-1048";
            $result = $event |  where { (($_.ID -eq "12" -or $_.ID -eq "13" -or $_.ID -eq "14") -and $_.message -match "TargetObject.*HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Ports" -and ($_.message -match "Details.*.*.dll" -or $_.message -match "Details.*.*.exe" -or $_.message -match "Details.*.*.bat" -or $_.message -match "Details.*.*.com" -or $_.message -match "Details.*.*C:")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
