﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.message -match "CommandLine.*.*whoami" -and ($_.message -match "CommandLine.*.*./Client/Common/" -or $_.message -match "CommandLine.*.*.\\Client\\Common\\")) -or $_.message -match "CommandLine.*.*C:\\Windows\\Temp\\Serv-U.bat")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_susp_servu_exploitation_cve_2021_35211";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_susp_servu_exploitation_cve_2021_35211";
            $detectedMessage = "Detects patterns as noticed in exploitation of Serv-U CVE-2021-35211 vulnerability by threat group DEV-0322 ";
            $result = $event | where { (($_.ID -eq "1") -and (($_.message -match "CommandLine.*.*whoami" -and ($_.message -match "CommandLine.*.*./Client/Common/" -or $_.message -match "CommandLine.*.*.\\Client\\Common\\")) -or $_.message -match "CommandLine.*.*C:\\Windows\\Temp\\Serv-U.bat")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;

            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
