﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.message -match "Image.*.*\tasksche.exe" -or $_.message -match "Image.*.*\mssecsvc.exe" -or $_.message -match "Image.*.*\taskdl.exe" -or $_.message -match "Image.*.*\taskhsvc.exe" -or $_.message -match "Image.*.*\taskse.exe" -or $_.message -match "Image.*.*\111.exe" -or $_.message -match "Image.*.*\lhdfrgui.exe" -or $_.message -match "Image.*.*\diskpart.exe" -or $_.message -match "Image.*.*\linuxnew.exe" -or $_.message -match "Image.*.*\wannacry.exe") -or $_.message -match "Image.*.*WanaDecryptor" -or ($_.message -match "CommandLine.*.*icacls" -and $_.message -match "CommandLine.*.*/grant" -and $_.message -match "CommandLine.*.*Everyone:F" -and $_.message -match "CommandLine.*.*/T" -and $_.message -match "CommandLine.*.*/C" -and $_.message -match "CommandLine.*.*/Q") -or ($_.message -match "CommandLine.*.*bcdedit" -and $_.message -match "CommandLine.*.*/set" -and $_.message -match "CommandLine.*.*{default}" -and $_.message -match "CommandLine.*.*recoveryenabled" -and $_.message -match "CommandLine.*.*no") -or ($_.message -match "CommandLine.*.*wbadmin" -and $_.message -match "CommandLine.*.*delete" -and $_.message -match "CommandLine.*.*catalog" -and $_.message -match "CommandLine.*.*-quiet") -or $_.message -match "CommandLine.*.*@Please_Read_Me@.txt")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_wannacry";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_wannacry";
            $detectedMessage = "Detects WannaCry ransomware activity";
            $result = $event | where { (($_.ID -eq "1") -and (($_.message -match "Image.*.*\\tasksche.exe" -or $_.message -match "Image.*.*\\mssecsvc.exe" -or $_.message -match "Image.*.*\\taskdl.exe" -or $_.message -match "Image.*.*\\taskhsvc.exe" -or $_.message -match "Image.*.*\\taskse.exe" -or $_.message -match "Image.*.*\\111.exe" -or $_.message -match "Image.*.*\\lhdfrgui.exe" -or $_.message -match "Image.*.*\\diskpart.exe" -or $_.message -match "Image.*.*\\linuxnew.exe" -or $_.message -match "Image.*.*\\wannacry.exe") -or $_.message -match "Image.*.*WanaDecryptor" -or ($_.message -match "CommandLine.*.*icacls" -and $_.message -match "CommandLine.*.*/grant" -and $_.message -match "CommandLine.*.*Everyone:F" -and $_.message -match "CommandLine.*.*/T" -and $_.message -match "CommandLine.*.*/C" -and $_.message -match "CommandLine.*.*/Q") -or ($_.message -match "CommandLine.*.*bcdedit" -and $_.message -match "CommandLine.*.*/set" -and $_.message -match "CommandLine.*.*{default}" -and $_.message -match "CommandLine.*.*recoveryenabled" -and $_.message -match "CommandLine.*.*no") -or ($_.message -match "CommandLine.*.*wbadmin" -and $_.message -match "CommandLine.*.*delete" -and $_.message -match "CommandLine.*.*catalog" -and $_.message -match "CommandLine.*.*-quiet") -or $_.message -match "CommandLine.*.*@Please_Read_Me@.txt")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;

            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
