﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "1" -and ($_.message -match "Image.*.*\wermgr.exe") -and ($_.message -match "ParentImage.*.*\rundll32.exe") -and ($_.message -match "ParentCommandLine.*.*DllRegisterServer")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_trickbot_wermgr";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_trickbot_wermgr";
            $detectedMessage = "Detects Trickbot malware process tree pattern in which rundll32.exe is parent of wermgr.exe ";
            $result = $event |  where { ($_.ID -eq "1" -and ($_.message -match "Image.*.*\\wermgr.exe") -and ($_.message -match "ParentImage.*.*\\rundll32.exe") -and ($_.message -match "ParentCommandLine.*.*DllRegisterServer")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
