﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "1" -and ($_.message -match "ParentImage.*.*\cmd.exe") -and ($_.message -match "Image.*.*\nltest.exe") -and ($_.message -match "CommandLine.*.*/domain_trusts /all_trusts")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_trickbot_recon_activity";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_trickbot_recon_activity";
            $result = $event | where { ($_.ID -eq "1" -and ($_.message -match "ParentImage.*.*\\cmd.exe") -and ($_.message -match "Image.*.*\\nltest.exe") -and ($_.message -match "CommandLine.*.*/domain_trusts /all_trusts")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
