﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.message -match "Image.*.*\wscript.exe" -or $_.message -match "Image.*.*\cscript.exe") -and ($_.message -match "CommandLine.*.*C:\Users\" -or $_.message -match "CommandLine.*.*C:\ProgramData\") -and ($_.message -match "CommandLine.*.*.jse" -or $_.message -match "CommandLine.*.*.vbe" -or $_.message -match "CommandLine.*.*.js" -or $_.message -match "CommandLine.*.*.vba" -or $_.message -match "CommandLine.*.*.vbs")) -and  -not ($_.message -match "ParentImage.*.*\winzip")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_script_dropper";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_script_dropper";
            $result = $event |  where { (($_.ID -eq "1") -and (($_.message -match "Image.*.*\\wscript.exe" -or $_.message -match "Image.*.*\\cscript.exe") -and ($_.message -match "CommandLine.*.*C:\\Users\\" -or $_.message -match "CommandLine.*.*C:\\ProgramData\\") -and ($_.message -match "CommandLine.*.*.jse" -or $_.message -match "CommandLine.*.*.vbe" -or $_.message -match "CommandLine.*.*.js" -or $_.message -match "CommandLine.*.*.vba" -or $_.message -match "CommandLine.*.*.vbs")) -and -not ($_.message -match "ParentImage.*.*\\winzip")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
