﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and ((($_.message -match "ParentImage.*.*\WinRAR.exe" -and $_.message -match "Image.*.*\wscript.exe") -or $_.message -match "CommandLine.*.* /c ping.exe -n 6 127.0.0.1 & type ") -or ($_.message -match "CommandLine.*.*regsvr32.exe" -and $_.message -match "CommandLine.*.*C:\ProgramData" -and $_.message -match "CommandLine.*.*.tmp"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_qbot";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_qbot";
            $detectedMessage = "Detects QBot like process executions";
            $result = $event | where { (($_.ID -eq "1") -and ((($_.message -match "ParentImage.*.*\\WinRAR.exe" -and $_.message -match "Image.*.*\\wscript.exe") -or $_.message -match "CommandLine.*.* /c ping.exe -n 6 127.0.0.1 & type ") -or ($_.message -match "CommandLine.*.*regsvr32.exe" -and $_.message -match "CommandLine.*.*C:\\ProgramData" -and $_.message -match "CommandLine.*.*.tmp"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;

            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
