﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.message -match "CommandLine.*.*\AppData\Local\Temp\" -and $_.message -match "CommandLine.*.*\.\pipe\") -or ($_.message -match "Image.*.*\rundll32.exe" -and $_.message -match "CommandLine.*.*.dat,#1") -or $_.message -match "perfc.dat")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_notpetya";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_notpetya";
            $detectedMessage = "Detects NotPetya ransomware activity in which the extracted passwords are passed back to the main module via named pipe, the file system journal of drive C is deleted and windows eventlogs are cleared using wevtutil";
            $result = $event |  where { (($_.ID -eq "1") -and (($_.message -match "CommandLine.*.*\\AppData\\Local\\Temp\\" -and $_.message -match "CommandLine.*.*\\.\\pipe\\") -or ($_.message -match "Image.*.*\\rundll32.exe" -and $_.message -match "CommandLine.*.*.dat,#1") -or $_.message -match "perfc.dat")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
