﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "1" -and ($_.message -match "ParentCommandLine.*C:\Windows\System32\" -or $_.message -match "ParentCommandLine.*C:\Windows\SysWOW64\") -and ($_.message -match "ParentCommandLine.*.*.exe") -and $_.message -match "CommandLine.*.*C:\Users\" -and (($_.message -match "CommandLine.*.*/c" -and $_.message -match "CommandLine.*.*del" -and $_.message -match "CommandLine.*.*\AppData\Local\Temp\") -or ($_.message -match "CommandLine.*.*/c" -and $_.message -match "CommandLine.*.*del" -and $_.message -match "CommandLine.*.*\Desktop\") -or ($_.message -match "CommandLine.*.*/C" -and $_.message -match "CommandLine.*.*type nul >" -and $_.message -match "CommandLine.*.*\Desktop\")) -and $_.message -match "CommandLine.*.*.exe") } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_formbook";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_formbook";
            $detectedMessage = "Detects Formbook like process executions that inject code into a set of files in the System32 folder, which executes a special command command line to";
            $result = $event | where { ($_.ID -eq "1" -and ($_.message -match "ParentCommandLine.*C:\\Windows\\System32\\" -or $_.message -match "ParentCommandLine.*C:\\Windows\\SysWOW64\\") -and ($_.message -match "ParentCommandLine.*.*.exe") -and $_.message -match "CommandLine.*.*C:\\Users\\" -and (($_.message -match "CommandLine.*.*/c" -and $_.message -match "CommandLine.*.*del" -and $_.message -match "CommandLine.*.*\\AppData\\Local\\Temp\\") -or ($_.message -match "CommandLine.*.*/c" -and $_.message -match "CommandLine.*.*del" -and $_.message -match "CommandLine.*.*\\Desktop\\") -or ($_.message -match "CommandLine.*.*/C" -and $_.message -match "CommandLine.*.*type nul >" -and $_.message -match "CommandLine.*.*\\Desktop\\")) -and $_.message -match "CommandLine.*.*.exe") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
