﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "1" -and ($_.message -match "CommandLine.*.* -e.* PAA" -or $_.message -match "CommandLine.*.*JABlAG4AdgA6AHUAcwBlAHIAcAByAG8AZgBpAGwAZQ" -or $_.message -match "CommandLine.*.*QAZQBuAHYAOgB1AHMAZQByAHAAcgBvAGYAaQBsAGUA" -or $_.message -match "CommandLine.*.*kAGUAbgB2ADoAdQBzAGUAcgBwAHIAbwBmAGkAbABlA" -or $_.message -match "CommandLine.*.*IgAoACcAKgAnACkAOwAkA" -or $_.message -match "CommandLine.*.*IAKAAnACoAJwApADsAJA" -or $_.message -match "CommandLine.*.*iACgAJwAqACcAKQA7ACQA" -or $_.message -match "CommandLine.*.*JABGAGwAeAByAGgAYwBmAGQ")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_emotet";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_emotet";
            $detectedMessage = "Detects all Emotet like process executions that are not covered by the more generic rules";
            $result = $event |  where { ($_.ID -eq "1" -and ($_.message -match "CommandLine.*.* -e.* PAA" -or $_.message -match "CommandLine.*.*JABlAG4AdgA6AHUAcwBlAHIAcAByAG8AZgBpAGwAZQ" -or $_.message -match "CommandLine.*.*QAZQBuAHYAOgB1AHMAZQByAHAAcgBvAGYAaQBsAGUA" -or $_.message -match "CommandLine.*.*kAGUAbgB2ADoAdQBzAGUAcgBwAHIAbwBmAGkAbABlA" -or $_.message -match "CommandLine.*.*IgAoACcAKgAnACkAOwAkA" -or $_.message -match "CommandLine.*.*IAKAAnACoAJwApADsAJA" -or $_.message -match "CommandLine.*.*iACgAJwAqACcAKQA7ACQA" -or $_.message -match "CommandLine.*.*JABGAGwAeAByAGgAYwBmAGQ")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
