﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.message -match "Image.*.*\svchost.exe" -and $_.message -match "CommandLine.*.*C:\Users\" -and $_.message -match "CommandLine.*.*\Desktop\") -or ($_.message -match "ParentImage.*.*\svchost.exe" -and ($_.ID -eq "1") -and (($_.message -match "Image.*.*\whoami.exe" -and $_.message -match "CommandLine.*.*all") -or (($_.message -match "Image.*.*\net.exe" -or $_.message -match "Image.*.*\net1.exe") -and $_.message -match "CommandLine.*.*view"))))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_malware_dridex";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_malware_dridex";
            $detectedMessage = "Detects typical Dridex process patterns";
            $result = $event |  where { (($_.ID -eq "1") -and (($_.message -match "Image.*.*\\svchost.exe" -and $_.message -match "CommandLine.*.*C:\\Users\\" -and $_.message -match "CommandLine.*.*\\Desktop\\") -or ($_.message -match "ParentImage.*.*\\svchost.exe" -and ($_.ID -eq "1") -and (($_.message -match "Image.*.*\\whoami.exe" -and $_.message -match "CommandLine.*.*all") -or (($_.message -match "Image.*.*\\net.exe" -or $_.message -match "Image.*.*\\net1.exe") -and $_.message -match "CommandLine.*.*view"))))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
