﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and $_.message -match "ParentImage.*.*\System32\dns.exe" -and  -not (($_.message -match "Image.*.*\System32\werfault.exe" -or $_.message -match "Image.*.*\System32\conhost.exe" -or $_.message -match "Image.*.*\System32\dnscmd.exe"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_exploit_cve_2020_1350";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_exploit_cve_2020_1350";
            $detectedMessage = "Detects exploitation of DNS RCE bug reported in CVE-2020-1350 by the detection of suspicious sub process";
            $result = $event |  where { (($_.ID -eq "1") -and $_.message -match "ParentImage.*.*\\System32\\dns.exe" -and -not (($_.message -match "Image.*.*\\System32\\werfault.exe" -or $_.message -match "Image.*.*\\System32\\conhost.exe" -or $_.message -match "Image.*.*\\System32\\dnscmd.exe"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
