﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.ID -eq "1" -and ($_.message -match "CommandLine.*.*Add-PrinterPort -Name") -and ($_.message -match "CommandLine.*.*.exe" -or $_.message -match "CommandLine.*.*.dll" -or $_.message -match "CommandLine.*.*.bat")) -or ($_.message -match "CommandLine.*.*Generic / Text Only"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_exploit_cve_2020_1048";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_exploit_cve_2020_1048";
            $detectedMessage = "Detects new commands that add new printer port which point to suspicious file";
            $result = $event | where { (($_.ID -eq "1") -and (($_.ID -eq "1" -and ($_.message -match "CommandLine.*.*Add-PrinterPort -Name") -and ($_.message -match "CommandLine.*.*.exe" -or $_.message -match "CommandLine.*.*.dll" -or $_.message -match "CommandLine.*.*.bat")) -or ($_.message -match "CommandLine.*.*Generic / Text Only"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
