﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "1" -and $_.message -match "ParentImage.*.*\consent.exe" -and $_.message -match "Image.*.*\iexplore.exe" -and $_.message -match "CommandLine.*.* http" -and ($_.ID -eq "1") -and ($_.message -match "IntegrityLevel.*System" -or $_.message -match "User.*NT AUTHORITY\SYSTEM")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_exploit_cve_2019_1388";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_exploit_cve_2019_1388";
            $detectedMessage = "Detects an exploitation attempt in which the UAC consent dialogue is used to invoke an Internet Explorer process running as LOCAL_SYSTEM";
            $result = $event |  where { ($_.ID -eq "1" -and $_.message -match "ParentImage.*.*\\consent.exe" -and $_.message -match "Image.*.*\\iexplore.exe" -and $_.message -match "CommandLine.*.* http" -and ($_.ID -eq "1") -and ($_.message -match "IntegrityLevel.*System" -or $_.message -match "User.*NT AUTHORITY\\SYSTEM")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
