﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and ($_.message -match "ParentCommandLine.*.*\cmd.exe" -and $_.message -match "ParentCommandLine.*.*/c" -and $_.message -match "ParentCommandLine.*.*C:\Windows\Setup\Scripts\" -and ($_.message -match "ParentCommandLine.*.*SetupComplete.cmd" -or $_.message -match "ParentCommandLine.*.*PartnerSetupComplete.cmd")) -and  -not (($_.message -match "Image.*C:\Windows\System32\" -or $_.message -match "Image.*C:\Windows\SysWOW64\" -or $_.message -match "Image.*C:\Windows\WinSxS\" -or $_.message -match "Image.*C:\Windows\Setup\"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_exploit_cve_2019_1378";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_exploit_cve_2019_1378";
            $detectedMessage = "Detects exploitation attempt of privilege escalation vulnerability via SetupComplete.cmd and PartnerSetupComplete.cmd described in CVE-2019-1378 ";
            $result = $event | where { (($_.ID -eq "1") -and ($_.message -match "ParentCommandLine.*.*\\cmd.exe" -and $_.message -match "ParentCommandLine.*.*/c" -and $_.message -match "ParentCommandLine.*.*C:\\Windows\\Setup\\Scripts\\" -and ($_.message -match "ParentCommandLine.*.*SetupComplete.cmd" -or $_.message -match "ParentCommandLine.*.*PartnerSetupComplete.cmd")) -and -not (($_.message -match "Image.*C:\\Windows\\System32\\" -or $_.message -match "Image.*C:\\Windows\\SysWOW64\\" -or $_.message -match "Image.*C:\\Windows\\WinSxS\\" -or $_.message -match "Image.*C:\\Windows\\Setup\\"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;

            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
