﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "10") -and ($_.message -match "TargetImage.*.*\verclsid.exe" -and $_.message -match "GrantedAccess.*0x1FFFFF") -and (($_.message -match "CallTrace.*.*|UNKNOWN(" -and $_.message -match "CallTrace.*.*VBE7.DLL") -or ($_.message -match "SourceImage.*.*\Microsoft Office\" -and $_.message -match "CallTrace.*.*|UNKNOWN"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "sysmon_malware_verclsid_shellcode";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "sysmon_malware_verclsid_shellcode";
            $result = $event |  where { (($_.ID -eq "10") -and ($_.message -match "TargetImage.*.*\\verclsid.exe" -and $_.message -match "GrantedAccess.*0x1FFFFF") -and (($_.message -match "CallTrace.*.*|UNKNOWN(" -and $_.message -match "CallTrace.*.*VBE7.DLL") -or ($_.message -match "SourceImage.*.*\\Microsoft Office\\" -and $_.message -match "CallTrace.*.*|UNKNOWN"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
