﻿# Get-WinEvent -LogName System | where {(($_.message -match "kali" -or $_.message -match "mimikatz") -and ($_.ID -eq "5805" -or $_.ID -eq "5723")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_possible_zerologon_exploitation_using_wellknown_tools";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_possible_zerologon_exploitation_using_wellknown_tools";
            $detectedMessage = "This rule is designed to detect attempts to exploit Zerologon (CVE-2020-1472) vulnerability using mimikatz zerologon module or other exploits from machine with ""kali"" hostname.";
            $result = $event | where {($_.ID -eq "5805" -or $_.ID -eq "5723") -and ($_.message -match "kali" -or $_.message -match "mimikatz") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
