﻿# Get-WinEvent | where {((($_.ID -eq "30" -and ($_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483648)" -or $_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483656)" -or $_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483652)" -or $_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483650)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=805306369)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=805306368)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=536870913)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=536870912)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=268435457)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=268435456)" -or $_.message -match "SearchFilter.*.*(objectCategory=groupPolicyContainer)" -or $_.message -match "SearchFilter.*.*(objectCategory=organizationalUnit)" -or $_.message -match "SearchFilter.*.*(objectCategory=Computer)" -or $_.message -match "SearchFilter.*.*(objectCategory=nTDSDSA)" -or $_.message -match "SearchFilter.*.*(objectCategory=server)" -or $_.message -match "SearchFilter.*.*(objectCategory=domain)" -or $_.message -match "SearchFilter.*.*(objectCategory=person)" -or $_.message -match "SearchFilter.*.*(objectCategory=group)" -or $_.message -match "SearchFilter.*.*(objectCategory=user)" -or $_.message -match "SearchFilter.*.*(objectClass=trustedDomain)" -or $_.message -match "SearchFilter.*.*(objectClass=computer)" -or $_.message -match "SearchFilter.*.*(objectClass=server)" -or $_.message -match "SearchFilter.*.*(objectClass=group)" -or $_.message -match "SearchFilter.*.*(objectClass=user)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=521)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=516)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=515)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=512)" -or $_.message -match "SearchFilter.*.*Domain Admins")) -and  -not ($_.ID -eq "30" -and ($_.message -match "SearchFilter.*.*(domainSid=.*)" -or $_.message -match "SearchFilter.*.*(objectSid=.*)"))) -or ($_.ID -eq "30" -and ($_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=4194304)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=2097152)" -or $_.message -match "SearchFilter.*.*!(userAccountControl:1.2.840.113556.1.4.803:=1048574)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=524288)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=65536)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=8192)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=544)" -or $_.message -match "SearchFilter.*.*!(UserAccountControl:1.2.840.113556.1.4.803:=2)" -or $_.message -match "SearchFilter.*.*msDS-AllowedToActOnBehalfOfOtherIdentity" -or $_.message -match "SearchFilter.*.*msDS-AllowedToDelegateTo" -or $_.message -match "SearchFilter.*.*(accountExpires=9223372036854775807)" -or $_.message -match "SearchFilter.*.*(accountExpires=0)" -or $_.message -match "SearchFilter.*.*(adminCount=1)" -or $_.message -match "SearchFilter.*.*ms-MCS-AdmPwd"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_ldap_recon";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_ldap_recon";
            $detectedMessage = "Detects possible Active Directory enumeration via LDAP";
            $result = $event |  where { ((($_.ID -eq "30" -and ($_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483648)" -or $_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483656)" -or $_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483652)" -or $_.message -match "SearchFilter.*.*(groupType:1.2.840.113556.1.4.803:=2147483650)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=805306369)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=805306368)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=536870913)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=536870912)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=268435457)" -or $_.message -match "SearchFilter.*.*(sAMAccountType=268435456)" -or $_.message -match "SearchFilter.*.*(objectCategory=groupPolicyContainer)" -or $_.message -match "SearchFilter.*.*(objectCategory=organizationalUnit)" -or $_.message -match "SearchFilter.*.*(objectCategory=Computer)" -or $_.message -match "SearchFilter.*.*(objectCategory=nTDSDSA)" -or $_.message -match "SearchFilter.*.*(objectCategory=server)" -or $_.message -match "SearchFilter.*.*(objectCategory=domain)" -or $_.message -match "SearchFilter.*.*(objectCategory=person)" -or $_.message -match "SearchFilter.*.*(objectCategory=group)" -or $_.message -match "SearchFilter.*.*(objectCategory=user)" -or $_.message -match "SearchFilter.*.*(objectClass=trustedDomain)" -or $_.message -match "SearchFilter.*.*(objectClass=computer)" -or $_.message -match "SearchFilter.*.*(objectClass=server)" -or $_.message -match "SearchFilter.*.*(objectClass=group)" -or $_.message -match "SearchFilter.*.*(objectClass=user)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=521)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=516)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=515)" -or $_.message -match "SearchFilter.*.*(primaryGroupID=512)" -or $_.message -match "SearchFilter.*.*Domain Admins")) -and -not ($_.ID -eq "30" -and ($_.message -match "SearchFilter.*.*(domainSid=.*)" -or $_.message -match "SearchFilter.*.*(objectSid=.*)"))) -or ($_.ID -eq "30" -and ($_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=4194304)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=2097152)" -or $_.message -match "SearchFilter.*.*!(userAccountControl:1.2.840.113556.1.4.803:=1048574)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=524288)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=65536)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=8192)" -or $_.message -match "SearchFilter.*.*(userAccountControl:1.2.840.113556.1.4.803:=544)" -or $_.message -match "SearchFilter.*.*!(UserAccountControl:1.2.840.113556.1.4.803:=2)" -or $_.message -match "SearchFilter.*.*msDS-AllowedToActOnBehalfOfOtherIdentity" -or $_.message -match "SearchFilter.*.*msDS-AllowedToDelegateTo" -or $_.message -match "SearchFilter.*.*(accountExpires=9223372036854775807)" -or $_.message -match "SearchFilter.*.*(accountExpires=0)" -or $_.message -match "SearchFilter.*.*(adminCount=1)" -or $_.message -match "SearchFilter.*.*ms-MCS-AdmPwd"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
