﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "3") -and ($_.message -match "Initiated.*true" -and ($_.message -match "4443" -or $_.message -match "2448" -or $_.message -match "8143" -or $_.message -match "1777" -or $_.message -match "1443" -or $_.message -match "243" -or $_.message -match "65535" -or $_.message -match "13506" -or $_.message -match "3360" -or $_.message -match "200" -or $_.message -match "198" -or $_.message -match "49180" -or $_.message -match "13507" -or $_.message -match "6625" -or $_.message -match "4444" -or $_.message -match "4438" -or $_.message -match "1904" -or $_.message -match "13505" -or $_.message -match "13504" -or $_.message -match "12102" -or $_.message -match "9631" -or $_.message -match "5445" -or $_.message -match "2443" -or $_.message -match "777" -or $_.message -match "13394" -or $_.message -match "13145" -or $_.message -match "12103" -or $_.message -match "5552" -or $_.message -match "3939" -or $_.message -match "3675" -or $_.message -match "666" -or $_.message -match "473" -or $_.message -match "5649" -or $_.message -match "4455" -or $_.message -match "4433" -or $_.message -match "1817" -or $_.message -match "100" -or $_.message -match "65520" -or $_.message -match "1960" -or $_.message -match "1515" -or $_.message -match "743" -or $_.message -match "700" -or $_.message -match "14154" -or $_.message -match "14103" -or $_.message -match "14102" -or $_.message -match "12322" -or $_.message -match "10101" -or $_.message -match "7210" -or $_.message -match "4040" -or $_.message -match "9943")) -and  -not ((($_.ID -eq "3") -and ($_.message -match "Image.*.*\Program Files" -or (($_.message -match "DestinationIp.*10." -or $_.message -match "DestinationIp.*192.168." -or $_.message -match "DestinationIp.*172.16." -or $_.message -match "DestinationIp.*172.17." -or $_.message -match "DestinationIp.*172.18." -or $_.message -match "DestinationIp.*172.19." -or $_.message -match "DestinationIp.*172.20." -or $_.message -match "DestinationIp.*172.21." -or $_.message -match "DestinationIp.*172.22." -or $_.message -match "DestinationIp.*172.23." -or $_.message -match "DestinationIp.*172.24." -or $_.message -match "DestinationIp.*172.25." -or $_.message -match "DestinationIp.*172.26." -or $_.message -match "DestinationIp.*172.27." -or $_.message -match "DestinationIp.*172.28." -or $_.message -match "DestinationIp.*172.29." -or $_.message -match "DestinationIp.*172.30." -or $_.message -match "DestinationIp.*172.31." -or $_.message -match "DestinationIp.*127.") -and $_.message -match "DestinationIsIpv6.*false"))))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "sysmon_malware_backconnect_ports";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "sysmon_malware_backconnect_ports";
            $detectedMessage = "Detects programs that connect to typical malware back connect ports based on statistical analysis from two different sandbox system databases";
            $result = $event |  where { (($_.ID -eq "3") -and ($_.message -match "Initiated.*true" -and ($_.message -match "4443" -or $_.message -match "2448" -or $_.message -match "8143" -or $_.message -match "1777" -or $_.message -match "1443" -or $_.message -match "243" -or $_.message -match "65535" -or $_.message -match "13506" -or $_.message -match "3360" -or $_.message -match "200" -or $_.message -match "198" -or $_.message -match "49180" -or $_.message -match "13507" -or $_.message -match "6625" -or $_.message -match "4444" -or $_.message -match "4438" -or $_.message -match "1904" -or $_.message -match "13505" -or $_.message -match "13504" -or $_.message -match "12102" -or $_.message -match "9631" -or $_.message -match "5445" -or $_.message -match "2443" -or $_.message -match "777" -or $_.message -match "13394" -or $_.message -match "13145" -or $_.message -match "12103" -or $_.message -match "5552" -or $_.message -match "3939" -or $_.message -match "3675" -or $_.message -match "666" -or $_.message -match "473" -or $_.message -match "5649" -or $_.message -match "4455" -or $_.message -match "4433" -or $_.message -match "1817" -or $_.message -match "100" -or $_.message -match "65520" -or $_.message -match "1960" -or $_.message -match "1515" -or $_.message -match "743" -or $_.message -match "700" -or $_.message -match "14154" -or $_.message -match "14103" -or $_.message -match "14102" -or $_.message -match "12322" -or $_.message -match "10101" -or $_.message -match "7210" -or $_.message -match "4040" -or $_.message -match "9943")) -and -not ((($_.ID -eq "3") -and ($_.message -match "Image.*.*\Program Files" -or (($_.message -match "DestinationIp.*10." -or $_.message -match "DestinationIp.*192.168." -or $_.message -match "DestinationIp.*172.16." -or $_.message -match "DestinationIp.*172.17." -or $_.message -match "DestinationIp.*172.18." -or $_.message -match "DestinationIp.*172.19." -or $_.message -match "DestinationIp.*172.20." -or $_.message -match "DestinationIp.*172.21." -or $_.message -match "DestinationIp.*172.22." -or $_.message -match "DestinationIp.*172.23." -or $_.message -match "DestinationIp.*172.24." -or $_.message -match "DestinationIp.*172.25." -or $_.message -match "DestinationIp.*172.26." -or $_.message -match "DestinationIp.*172.27." -or $_.message -match "DestinationIp.*172.28." -or $_.message -match "DestinationIp.*172.29." -or $_.message -match "DestinationIp.*172.30." -or $_.message -match "DestinationIp.*172.31." -or $_.message -match "DestinationIp.*127.") -and $_.message -match "DestinationIsIpv6.*false"))))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
