﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {($_.ID -eq "11" -and ($_.message -match "TargetFilename.*.*\AppData\Local\Microsoft\Cache134.dat" -or $_.message -match "TargetFilename.*.*\AppData\Local\Microsoft\ExplorerSync.db")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_mal_octopus_scanner";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_mal_octopus_scanner";
            $detectedMessage = "Detects Octopus Scanner Malware.";
            $result = $event |  where { ($_.ID -eq "11" -and ($_.message -match "TargetFilename.*.*\\AppData\\Local\\Microsoft\\Cache134.dat" -or $_.message -match "TargetFilename.*.*\\AppData\\Local\\Microsoft\\ExplorerSync.db")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
