﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {((($_.ID -eq "12" -or $_.ID -eq "13" -or $_.ID -eq "14")) -and (($_.message -match "HKLM\HARDWARE\{804423C2-F490-4ac3-BFA5-13DEDE63A71A}" -or $_.message -match "HKLM\HARDWARE\{A5124AF5-DF23-49bf-B0ED-A18ED3DEA027}" -or $_.message -match "HKLM\HARDWARE\{2DB80286-1784-48b5-A751-B6ED1F490303}") -or ($_.message -match "TargetObject.*HKLM\SYSTEM\Setup\PrintResponsor\"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_mal_flowcloud";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_mal_flowcloud";
            $detectedMessage = "Detects FlowCloud malware from threat group TA410.";
            $result = $event |  where { ((($_.ID -eq "12" -or $_.ID -eq "13" -or $_.ID -eq "14")) -and (($_.message -match "HKLM\\HARDWARE\\{804423C2-F490-4ac3-BFA5-13DEDE63A71A}" -or $_.message -match "HKLM\\HARDWARE\\{A5124AF5-DF23-49bf-B0ED-A18ED3DEA027}" -or $_.message -match "HKLM\\HARDWARE\\{2DB80286-1784-48b5-A751-B6ED1F490303}") -or ($_.message -match "TargetObject.*HKLM\\SYSTEM\\Setup\\PrintResponsor\\"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
