﻿# Get-WinEvent -LogName Microsoft-Windows-Sysmon/Operational | where {(($_.ID -eq "1") -and (($_.message -match "CommandLine.*.*=[char][byte]('0x'+" -or $_.message -match "CommandLine.*.* -work worker0 -path ") -or (($_.message -match "ParentCommandLine.*.*DllHost.exe /Processid:{3E5FC7F9-9A51-4367-9063-A120244FBEC7}") -and ($_.message -match "Image.*.*\AppData\Local\Temp\")))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_mal_darkside";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_mal_darkside";
            $detectedMessage = "Detects DarkSide Ransomware and helpers";
            $result = $event | where { (($_.ID -eq "1") -and (($_.message -match "CommandLine.*.*=[char][byte]\(\'0x\'+" -or $_.message -match "CommandLine.*.* -work worker0 -path ") -or (($_.message -match "ParentCommandLine.*.*DllHost.exe /Processid:{3E5FC7F9-9A51-4367-9063-A120244FBEC7}") -and ($_.message -match "Image.*.*\\AppData\\Local\\Temp\\")))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMesssage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
