﻿# Get-WinEvent | where {(($_.message -match "FileName.*C:\\Windows\\" -or $_.message -match "FileName.*C:\\Temp\\" -or $_.message -match "FileName.*C:\\PerfLogs\\" -or $_.message -match "FileName.*C:\\Users\\Public\\" -or $_.message -match "FileName.*C:\\Users\\Default\\") -or ($_.message -match "FileName.*.*\\Client\\" -or $_.message -match "FileName.*.*\\tsclient\\" -or $_.message -match "FileName.*.*\\inetpub\\" -or $_.message -match "FileName.*.*/www/" -or $_.message -match "FileName.*.*apache" -or $_.message -match "FileName.*.*tomcat" -or $_.message -match "FileName.*.*nginx" -or $_.message -match "FileName.*.*weblogic") -or ($_.message -match "Filename.*.*.ps1" -or $_.message -match "Filename.*.*.psm1" -or $_.message -match "Filename.*.*.vbs" -or $_.message -match "Filename.*.*.bat" -or $_.message -match "Filename.*.*.cmd" -or $_.message -match "Filename.*.*.sh" -or $_.message -match "Filename.*.*.chm" -or $_.message -match "Filename.*.*.xml" -or $_.message -match "Filename.*.*.txt" -or $_.message -match "Filename.*.*.jsp" -or $_.message -match "Filename.*.*.jspx" -or $_.message -match "Filename.*.*.asp" -or $_.message -match "Filename.*.*.aspx" -or $_.message -match "Filename.*.*.ashx" -or $_.message -match "Filename.*.*.asax" -or $_.message -match "Filename.*.*.asmx" -or $_.message -match "Filename.*.*.php" -or $_.message -match "Filename.*.*.cfm" -or $_.message -match "Filename.*.*.py" -or $_.message -match "Filename.*.*.pyc" -or $_.message -match "Filename.*.*.pl" -or $_.message -match "Filename.*.*.rb" -or $_.message -match "Filename.*.*.cgi" -or $_.message -match "Filename.*.*.war" -or $_.message -match "Filename.*.*.ear" -or $_.message -match "Filename.*.*.hta" -or $_.message -match "Filename.*.*.lnk" -or $_.message -match "Filename.*.*.scf" -or $_.message -match "Filename.*.*.sct" -or $_.message -match "Filename.*.*.vbe" -or $_.message -match "Filename.*.*.wsf" -or $_.message -match "Filename.*.*.wsh" -or $_.message -match "Filename.*.*.gif" -or $_.message -match "Filename.*.*.png" -or $_.message -match "Filename.*.*.jpg" -or $_.message -match "Filename.*.*.jpeg" -or $_.message -match "Filename.*.*.svg" -or $_.message -match "Filename.*.*.dat")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message


function Add-Rule {

    $ruleName = "av_relevant_files";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "av_relevant_files";
            $detectedMessage = "Detects an Antivirus alert in a highly relevant file path or with a relevant file name.";
            $result = $event | where { (($_.message -match "FileName.*C:\\Windows\\" -or $_.message -match "FileName.*C:\\Temp\\" -or $_.message -match "FileName.*C:\\PerfLogs\\" -or $_.message -match "FileName.*C:\\Users\\Public\\" -or $_.message -match "FileName.*C:\\Users\\Default\\") -or ($_.message -match "FileName.*.*\\Client\\" -or $_.message -match "FileName.*.*\\tsclient\\" -or $_.message -match "FileName.*.*\\inetpub\\" -or $_.message -match "FileName.*.*/www/" -or $_.message -match "FileName.*.*apache" -or $_.message -match "FileName.*.*tomcat" -or $_.message -match "FileName.*.*nginx" -or $_.message -match "FileName.*.*weblogic") -or ($_.message -match "Filename.*.*.ps1" -or $_.message -match "Filename.*.*.psm1" -or $_.message -match "Filename.*.*.vbs" -or $_.message -match "Filename.*.*.bat" -or $_.message -match "Filename.*.*.cmd" -or $_.message -match "Filename.*.*.sh" -or $_.message -match "Filename.*.*.chm" -or $_.message -match "Filename.*.*.xml" -or $_.message -match "Filename.*.*.txt" -or $_.message -match "Filename.*.*.jsp" -or $_.message -match "Filename.*.*.jspx" -or $_.message -match "Filename.*.*.asp" -or $_.message -match "Filename.*.*.aspx" -or $_.message -match "Filename.*.*.ashx" -or $_.message -match "Filename.*.*.asax" -or $_.message -match "Filename.*.*.asmx" -or $_.message -match "Filename.*.*.php" -or $_.message -match "Filename.*.*.cfm" -or $_.message -match "Filename.*.*.py" -or $_.message -match "Filename.*.*.pyc" -or $_.message -match "Filename.*.*.pl" -or $_.message -match "Filename.*.*.rb" -or $_.message -match "Filename.*.*.cgi" -or $_.message -match "Filename.*.*.war" -or $_.message -match "Filename.*.*.ear" -or $_.message -match "Filename.*.*.hta" -or $_.message -match "Filename.*.*.lnk" -or $_.message -match "Filename.*.*.scf" -or $_.message -match "Filename.*.*.sct" -or $_.message -match "Filename.*.*.vbe" -or $_.message -match "Filename.*.*.wsf" -or $_.message -match "Filename.*.*.wsh" -or $_.message -match "Filename.*.*.gif" -or $_.message -match "Filename.*.*.png" -or $_.message -match "Filename.*.*.jpg" -or $_.message -match "Filename.*.*.jpeg" -or $_.message -match "Filename.*.*.svg" -or $_.message -match "Filename.*.*.dat")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}