﻿# Get-WinEvent | where {($_.message -match "Signature.*.*DumpCreds" -or $_.message -match "Signature.*.*Mimikatz" -or $_.message -match "Signature.*.*PWCrack" -or $_.message -match "Signature.*.*HTool/WCE" -or $_.message -match "Signature.*.*PSWtool" -or $_.message -match "Signature.*.*PWDump" -or $_.message -match "Signature.*.*SecurityTool" -or $_.message -match "Signature.*.*PShlSpy" -or $_.message -match "Signature.*.*Rubeus" -or $_.message -match "Signature.*.*Kekeo" -or $_.message -match "Signature.*.*LsassDump" -or $_.message -match "Signature.*.*Outflank") } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "av_password_dumper";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "av_password_dumper";
            $detectedMessage = "Detects a highly relevant Antivirus alert that reports a password dumper.";
            $result = $event | where { ($_.message -match "Signature.*.*DumpCreds" -or $_.message -match "Signature.*.*Mimikatz" -or $_.message -match "Signature.*.*PWCrack" -or $_.message -match "Signature.*.*HTool/WCE" -or $_.message -match "Signature.*.*PSWtool" -or $_.message -match "Signature.*.*PWDump" -or $_.message -match "Signature.*.*SecurityTool" -or $_.message -match "Signature.*.*PShlSpy" -or $_.message -match "Signature.*.*Rubeus" -or $_.message -match "Signature.*.*Kekeo" -or $_.message -match "Signature.*.*LsassDump" -or $_.message -match "Signature.*.*Outflank") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}