﻿# Get-WinEvent | where { ($_.message -match "Signature.*.*MeteTool" -or $_.message -match "Signature.*.*MPreter" -or $_.message -match "Signature.*.*Meterpreter" -or $_.message -match "Signature.*.*Metasploit" -or $_.message -match "Signature.*.*PowerSploit" -or $_.message -match "Signature.*.*CobaltSrike" -or $_.message -match "Signature.*.*Swrort" -or $_.message -match "Signature.*.*Rozena" -or $_.message -match "Signature.*.*Backdoor.Cobalt" -or $_.message -match "Signature.*.*CobaltStr" -or $_.message -match "Signature.*.*COBEACON" -or $_.message -match "Signature.*.*Cometer" -or $_.message -match "Signature.*.*Razy") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message


function Add-Rule {

    if ($isLiveAnalysis) {
        # LiveAnalysysが必要か確認する
    }
    else {
        $ruleName = "av_exploing";
        $detectRule = {
            
            function Search-DetectableEvents {
                param (
                    $event
                )
                $ruleName = "av_exploing";
                $detectedMessage = "Detects a highly relevant Antivirus alert that reports an exploitation framework";
                $result = $event | where { ($_.message -match "Signature.*.*MeteTool" -or $_.message -match "Signature.*.*MPreter" -or $_.message -match "Signature.*.*Meterpreter" -or $_.message -match "Signature.*.*Metasploit" -or $_.message -match "Signature.*.*PowerSploit" -or $_.message -match "Signature.*.*CobaltSrike" -or $_.message -match "Signature.*.*Swrort" -or $_.message -match "Signature.*.*Rozena" -or $_.message -match "Signature.*.*Backdoor.Cobalt" -or $_.message -match "Signature.*.*CobaltStr" -or $_.message -match "Signature.*.*COBEACON" -or $_.message -match "Signature.*.*Cometer" -or $_.message -match "Signature.*.*Razy") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message
                if ($result) {
                    Write-Output ""; 
                    Write-Output "Detected! RuleName:$ruleName";
                    Write-Output $detectedMessage;
                    Write-Output $result;
                    Write-Output ""; 
                }
            }
            . Search-DetectableEvents $args;
        } 
        if(! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    } else {
       Write-Host "Rule Import Error"  -Foreground Yellow;
    }
    }
}