﻿# Get-WinEvent -LogName System | where {(($_.ID -eq "56" -or $_.ID -eq "50") -and $_.message -match "Source.*TermDD") } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_rdp_potential_cve-2019-0708";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_rdp_potential_cve-2019-0708";
            $detectedMessage = "Detect suspicious error on protocol RDP, potential CVE-2019-0708";
            $result = $event |  where { (($_.ID -eq "56" -or $_.ID -eq "50") -and $_.message -match "Source.*TermDD") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
