﻿# Get-WinEvent -LogName System | where {($_.ID -eq "55" -and $_.message -match "Origin.*File System Driver" -and $_.message -match "Description.*.*contains a corrupted file record" -and $_.message -match "Description.*.*The name of the file is "\"") } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_ntfs_vuln_exploit";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_ntfs_vuln_exploit";
            $detectedMessage = "This the exploitation of a NTFS vulnerability as reported without many details via Twitter";
            $result = $event |  where { ($_.ID -eq "55" -and $_.message -match "Origin.*File System Driver" -and $_.message -match "Description.*.*contains a corrupted file record" -and $_.message -match "Description.*.*The name of the file is ""\\""") } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
