﻿# Get-WinEvent -LogName Microsoft-Windows-PrintService/Operational | where {($_.ID -eq "316" -and ($_.message -match "UNIDRV.DLL, kernelbase.dll, " -or $_.message -match " 123 " -or $_.message -match " 1234 " -or $_.message -match "mimispool")) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_exploit_cve_2021_1675_printspooler_operational";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_exploit_cve_2021_1675_printspooler_operational";
            $detectedMessage = "Detects driver load events print service operational log that are a sign of successful exploitation attempts against print spooler vulnerability CVE-2021-1675";
            $result = $event |  where { ($_.ID -eq "316" -and ($_.message -match "UNIDRV.DLL, kernelbase.dll, " -or $_.message -match " 123 " -or $_.message -match " 1234 " -or $_.message -match "mimispool")) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
