﻿# Get-WinEvent -LogName Microsoft-Windows-PrintService/Admin | where {(((($_.ID -eq "808" -or $_.ID -eq "4909") -and ($_.message -match "0x45A" -or $_.message -match "0x7e")) -or ($_.message -match "The print spooler failed to load a plug-in module" -or $_.message -match "MyExploit.dll" -or $_.message -match "evil.dll" -or $_.message -match "ddCube.dll" -or $_.message -match "ev.dll" -or $_.message -match "ev2.dll" -or $_.message -match "main64.dll" -or $_.message -match "mimilib.dll" -or $_.message -match "mimispool.dll"))) } | select TimeCreated,Id,RecordId,ProcessId,MachineName,Message

function Add-Rule {

    $ruleName = "win_exploit_cve_2021_1675_printspooler";
    $detectRule = {
        
        function Search-DetectableEvents {
            param (
                $event
            )
            
            $ruleName = "win_exploit_cve_2021_1675_printspooler";
            $detectedMessage = "Detects events of driver load errors in print service logs that could be a sign of successful exploitation attempts of print spooler vulnerability CVE-2021-1675"
            $result = $event |  where { (((($_.ID -eq "808" -or $_.ID -eq "4909") -and ($_.message -match "0x45A" -or $_.message -match "0x7e")) -or ($_.message -match "The print spooler failed to load a plug-in module" -or $_.message -match "MyExploit.dll" -or $_.message -match "evil.dll" -or $_.message -match "ddCube.dll" -or $_.message -match "
ev.dll" -or $_.message -match "ev2.dll" -or $_.message -match "main64.dll" -or $_.message -match "mimilib.dll" -or $_.message -match "mimispool.dll"))) } | select TimeCreated, Id, RecordId, ProcessId, MachineName, Message;
            if ($result -and $result.Count -ne 0) {
                Write-Output ""; 
                Write-Output "Detected! RuleName:$ruleName";
                Write-Output $detectedMessage;
                Write-Output $result;
                Write-Output ""; 
            }
        };
        . Search-DetectableEvents $args;
    };
    if (! $ruleStack[$ruleName]) {
        $ruleStack.Add($ruleName, $detectRule);
    }
    else {
        Write-Host "Rule Import Error"  -Foreground Yellow;
    }
}
