React                  = require 'react'
DraggableModal         = require 'components/draggable-modal'
SmallButton            = require 'components/buttons/small-button'
HelpButton             = require 'components/buttons/help-button'
BadSubjectButton       = require 'components/buttons/bad-subject-button'
IllegibleSubjectButton = require 'components/buttons/illegible-subject-button'
DatePicker             = require 'react-datepicker'
moment                 = require 'moment'

TextTool = React.createClass
  displayName: 'TextTool'

  getInitialState: ->
    annotation: @props.annotation ? {}
    viewerSize: @props.viewerSize
    autocompleting: false
    pressed_keys: {}

    # The selectedDate attribute of the DatePicker component will store the
    # currently selected date. This object must be of type moment() or blank.
    # If blank, the input element within the DatePicker component will display the
    # text identified in the placeholderText attribute (specified below)
    selectedDate: moment(this.props.subject.meta_data.year + "-01-01")

  # this can go into a mixin? (common across all transcribe tools)
  getPosition: (data) ->
    return x: null, y: null if ! data.x?

    yPad = 20
    switch data.toolName
      when 'rectangleTool'
        x = data.x
        y = parseFloat(data.y) + parseFloat(data.height) + yPad
      when 'textRowTool'
        x = data.x
        y = data.yLower + yPad
      else # default for pointTool
        x = data.x
        y = data.y + yPad if data.y?
    x = @props.subject.width / 2 if ! x?
    y = @props.subject.height / 2 if ! y?
    return {x,y}

  getDefaultProps: ->
    annotation: {}
    annotation_key: null
    task: null
    subject: null
    standalone: true
    focus: true
    inputType: 'text'

  componentWillUnmount: ->
    tool_config = @toolConfig()
    if tool_config.suggest == 'common'
      el = $(@refs.input0.getDOMNode())
      el.autocomplete 'destroy' if el.autocomplete?

  toolConfig: ->
    @props.tool_config ? @props.task.tool_config

  # Set focus on input:
  focus: ->
    el = $(@refs.input0?.getDOMNode())
    if el? && el.length
      el.focus()

  componentWillReceiveProps: (new_props) ->
    # PB: Note this func is defined principally to allow a parent composite-tool
    # to set focus on a child tool via props but this consistently fails to
    # actually set focus - probably because the el.focus() call is made right
    # before an onkeyup event or something, which quietly reverses it.
    if new_props.focus
      @focus()

    @applyAutoComplete()

    # Required to ensure tool has cleared annotation even if tool doesn't unmount between tasks:
    @setState
      annotation: new_props.annotation ? {}
      viewerSize: new_props.viewerSize

    # if we receive props that designate a `date_end` value,
    # and this component is responsible for setting the date_end,
    # set the date in state
    if new_props.date_end != @props.date_end
      if @props.annotation_key == 'ey_transcribed_date_stop'
        @setState
          selectedDate: moment(new_props.date_end)

  shouldComponentUpdate: ->
    true

  componentDidMount: ->
    @applyAutoComplete()
    @focus() if @props.focus

  componentDidUpdate: ->
    @applyAutoComplete()
    @focus() if @props.focus

  applyAutoComplete: ->
    if @isMounted() && @toolConfig().suggest == 'common'
      el = $(@refs.input0?.getDOMNode())
      el.autocomplete
        open: ( => @setState autocompleting: true )
        close: => setTimeout( (=> @setState(autocompleting: false)), 1000)
        select: (e, ui) => @updateValue(ui.item.value)
        source: (request, response) =>
          field = "#{@props.task.key}:#{@fieldKey()}"
          $.ajax
            url: "/classifications/terms/#{@props.workflow.id}/#{field}"
            dataType: "json"
            data:
              q: request.term
            success: ( data ) =>
              response( data )
        minLength: 3

  # Expects size hash with:
  #   w: [viewer width]
  #   h: [viewer height]
  #   scale:
  #     horizontal: [horiz scaling of image to fit within above vals]
  #     vertical:   [vert scaling of image..]
  onViewerResize: (size) ->
    @setState
      viewerSize: size

  # this can go into a mixin? (common across all transcribe tools)
  # NOTE: doesn't get called unless @props.standalone is true
  commitAnnotation: ->
    # push focus back to the first input in the transcribe box
    document.querySelector('.draggable-modal.transcribe-tool').querySelector('input').focus()

    ann = @state.annotation
    @props.onComplete ann

    if @props.transcribeMode is 'page' or @props.transcribeMode is 'single'
      if @props.isLastSubject and not @props.task.next_task?
        @props.returnToMarking()

  # Get key to use in annotations hash (i.e. typically 'value', unless included in composite tool)
  fieldKey: ->
    if @props.standalone
      'value'
    else
      @props.annotation_key

  getCaret: ()->
    el = $(@refs.input0?.getDOMNode())

  updateValue: (val) ->
    newAnnotation = @state.annotation
    newAnnotation[@fieldKey()] = val

    # if composite-tool is used, this will be a callback to CompositeTool::handleChange()
    # otherwise, it'll be a callback to Transcribe::handleDataFromTool()
    @props.onChange(newAnnotation) # report updated annotation to parent

  handleChange: (e) ->
    @updateValue e.target.value

  # Event handler that parses Moment.js objects
  handleDateChange: (e) ->
    if not e? or e.length is 0
      this.setState
        selectedDate: moment( this.props.subject.meta_data.year + "-01-01" )
      this.updateValue moment( this.props.subject.meta_data.year + "-01-01" )

    else
      this.setState
        selectedDate: moment(e._d)
      this.updateValue e._d

  handleKeyDown: (e) ->
    # store the fact that the user is pressing another key
    keys = @state.pressed_keys
    keys[e.keyCode] = true
    @setState
      pressed_keys: keys

    # if the user has pressed CTRL+a or COMMAND+a focus the input
    # COMMAND = 91
    # CTRL = 17
    # a = 65
    if (@state.pressed_keys[91] and @state.pressed_keys[65]) ||
       (@state.pressed_keys[17] and @state.pressed_keys[65])
      e.target.select()
      e.preventDefault()
      e.stopPropagation()

    # only set state if we're not selecting the input values
    else
      @handleChange(e) # updates any autocomplete values

    if (! @state.autocompleting && [13].indexOf(e.keyCode) >= 0) && !e.shiftKey# ENTER
      @commitAnnotation()
    else if e.keyCode == 13 && e.shiftKey
      text_area =  $("textarea")
      the_text = text_area.val()
      the_text = the_text.concat("/n")
      text_area.val(the_text)

  handleKeyUp: (e) ->
    # store the fact that the user is no longer pressing this key
    keys = @state.pressed_keys
    keys[e.keyCode] = false
    @setState
      pressed_keys: keys

  handleBadMark: ()->
    newAnnotation = []
    newAnnotation["low_quality_subject"]

  findMinDate: ()->
    return moment( this.props.subject.meta_data.year + "-01-01" )

  findMaxDate: ()->
    return moment( String(parseInt(this.props.subject.meta_data.year) + 1) + "-01-01" )

  render: ->
    return null if @props.loading # hide transcribe tool while loading image

    val = @state.annotation[@fieldKey()]
    val = '' if ! val?

    unless @props.standalone
      label = @props.label ? ''
      label = label[0] if Array.isArray(label)
    else
      label = @props.task.instruction

    ref = @props.ref || "input0"

    # Grab examples either from examples in top level of task or (for composite tool) inside this field's option hash:
    examples = @props.task.examples ? ( t for t in (@props.task.tool_config?.options ? []) when t.value==@props.annotation_key )[0]?.examples

    # create component input field(s)
    tool_content =
      <div className="input-field active">

        <label dangerouslySetInnerHTML={{__html: marked( label ) }} />

        { if examples
          <ul className="task-examples">
          { for ex,i in examples
              <li key={i}>{ex}</li>
          }
          </ul>
        }

        {
          atts =
            ref: ref
            key: "#{@props.task.key}.#{@props.annotation_key}"
            "data-task_key": @props.task.key
            onKeyDown: @handleKeyDown
            onKeyUp: @handleKeyUp
            onChange: @handleChange
            onFocus: ( () => @props.onInputFocus? @props.annotation_key )
            value: val
            disabled: @props.badSubject

          if @props.inputType == "text"
            <input type="text" value={val} {...atts} />

          else if @props.inputType == "textarea"
            <textarea key={@props.task.key} value={val} {...atts} />

          else if @props.inputType == "number"
            # Let's not make it input[type=number] because we don't want the browser to absolutely *force* numeric; We should coerce numerics without obliging
            <input type="text" value={val} {...atts} />

          # If this is a date input, set new attributes
          else if @props.inputType == "date"
            atts =
              ref: ref
              key: "#{@props.task.key}.#{@props.annotation_key}"
              "data-task_key": @props.task.key
              onKeyDown: @handleKeyDown
              onFocus: ( () => @props.onInputFocus? @props.annotation_key )
              # value will control the value attribute of the input element within the DatePicker
              disabled: @props.badSubject

            <DatePicker
              selected={this.state.selectedDate}
              onChange={@handleDateChange}
              placeholderText="Click to select a date"
              minDate={ moment( this.props.subject.meta_data.year + "-01-01" ) }
              maxDate={ moment( String(parseInt(this.props.subject.meta_data.year) + 1) + "-01-01" ) }
              type="custom-date"
              {...atts}
            />

          else console.warn "Invalid inputType specified: #{@props.inputType}"

        }
      </div>

    if @props.standalone # 'standalone' true if component handles own mouse events

      buttons = []

      if @props.onShowHelp?
        buttons.push <HelpButton key="help-button" onClick={@props.onShowHelp}/>

      if @props.onBadSubject?
        buttons.push <BadSubjectButton key="bad-subject-button" label={"Bad #{@props.project.term('mark')}"} active={@props.badSubject} onClick={@props.onBadSubject} />

      if @props.onIllegibleSubject?
        buttons.push <IllegibleSubjectButton key="illegal-subject-button" active={@props.illegibleSubject} onClick={@props.onIllegibleSubject} />

      buttonLabel =
        if @props.task.next_task?
         'Continue'
        else
          if @props.isLastSubject and ( @props.transcribeMode is 'page' or @props.transcribeMode is 'single' )
            'Return to Marking'
          else 'Next Entry'

      buttons.push <SmallButton label={buttonLabel} key="done-button" onClick={@commitAnnotation} />

      {x,y} = @getPosition @props.subject.region

      tool_content = <DraggableModal
        x={x*@props.scale.horizontal + @props.scale.offsetX}
        y={y*@props.scale.vertical + @props.scale.offsetY}
        buttons={buttons}
        classes="transcribe-tool"
        toggleYaleTutorial={@props.toggleYaleTutorial}
        >

          {tool_content}

      </DraggableModal>

    <div>
      {tool_content}
    </div>

module.exports = TextTool
