<div align ="center">
  <h1>
    Algorithm Guide
  </h1>
  </div>

本仓库带你系统掌握程序员必知必会的**算法**和**数据结构**

本仓库主要有**两个分支**：

+ **master分支**：最近的新分支，也是以后日常维护的主分支，内容为算法和数据结构的教程。

+ **Collections 分支**：以前的主分支，整理了算法和数据结构的资料，现作为辅助分支：[这里访问](https://github.com/Xunzhuo/Algorithms-in-4-Steps/tree/Collections)

 > **算法部分**基本完成，**数据结构**还有很多未完成部分，空闲时会加快完善

## 目录：

1. [算法篇](#算法篇)
2. [数据结构篇](#数据结构篇)
3. [刷题练习篇](#刷题练习篇)

## 算法篇

+ [一、复杂度分析](algorithm/analysis.md)
+ [二、高精度算法](algorithm/big-num.md)
+ [三、排序算法](algorithm/sort.md)
+ [四、递推算法](algorithm/recursion.md)
+ [五 、递归算法](algorithm/recursion-2.md)
+ [六、分治算法](algorithm/bi-divide.md)
+ [七、贪心算法](algorithm/greedy.md)
+ [八、广度优先搜索算法](algorithm/bfs.md)
+ [九、深度优先搜索算法](algorithm/dfs.md)
+ [十、回溯算法](algorithm/backtrace.md)
+ [十一、动态规划](algorithm/dynamic%20programming.md)
+ [十二、字符串算法](algorithm/string.md) 

## 数据结构篇

+ [一、栈](data-structure/stack.md)
+ [二、队列](data-structure/queue.md)
+ [三、树](data-structure/tree.md) 
+ [四、堆](data-structure/heap.md) 
+ [五、图论算法 ](data-structure/graph.md) 
+ [六、并查集](data-structure/DisjointSets.md)  
+ [七、最小生成树](data-structure/kruskal.md) 
+ [八、拓扑排序与关键路径](data-structure/key-path.md) 
+ [九、线段树](data-structure/line-tree.md) 
+ [十、树状数组](data-structure/tree-array.md) 

##  刷题练习篇

在掌握了重要的算法和数据结构之后，需要练习巩固

#### **网站的选择？**

推荐 **LeetCode**，[这里访问](https://leetcode-cn.com/)

#### **刷哪些题目？**

1. 如果你**时间紧张**：可以练习**LeetCode**的**热门推荐**：

   ![image-20201220164553273](https://picreso.oss-cn-beijing.aliyuncs.com/image-20201220164553273.png)

   比如：[Leetcode 热题 Hot 100](https://leetcode-cn.com/problemset/leetcode-hot-100/) 和 [LeetCode 精选 TOP 面试题](https://leetcode-cn.com/problemset/leetcode-top/)

2. 如果你**时间充裕**：可以按以下分类，系统练习：

   + **专题一：数组(`Chapter1_Array`)**
   + **专题二：链表(`Chapter2_list`)**
   + **专题三：字符串(`Chapter3_String`)**
   + **专题四：栈(`Chapter4_Stack`)**
   + **专题五：树(`Chapter5_Tree`)**
   + **专题六：排序(`Chapter6_Sort`)**
   + **专题七：查找(`Chapter7_Search`)**
   + **专题八：暴力解法(`Chapter8_Violence`)**
   + **专题九：BFS(`Chapter9_BFS`)**
   + **专题十：DFS(`Chapter10_DFS`)**
   + **专题十一：分治(`Chapter11_Paritition`)**
   + **专题十二：贪心(`Chapter12_Greedy`)**
   + **专题十三：动态规划(`Chapter13_DP`)**
   + **专题十四：图(`Chapter14_Graph`)**
   + **专题十五：不定类型(`Chapter15_Unspecific`)**

#### 练习策略

+ **第一遍**：**先思考**，如果没思路，可以看题解，结合其他人的题解刷。总结自己是否在思路上有问题，或者是否算法与数据结构基础上有问题，掌握本题的类型，思考方式，最优题解。
+ **第二遍**：**回忆最优解法**，**尝试直接写**，并与之前自己写过的解答作比对，总结问题和方法。
+ **第三遍**：提升**刷题速度**和**一题多解**，拿出一个题，就能够知道其考察重点，解题方法，在短时间内写出解答，并且思考多种解决办法。

