## SkillSync

SkillSync is a web-based application designed to streamline the recruitment process by efficiently managing and analyzing job applications and resumes. It helps recruiters and hiring managers organize, track, and evaluate candidates based on job descriptions and qualifications.

Web link: https://myskillsync.streamlit.app/

Features:
- Resume Management: Upload, store, and organize resumes and job applications.
- Keyword Matching: Automatically match resumes with job descriptions using AI-driven algorithms.
- Analytics Dashboard: Visualize recruitment metrics, applicant status, and hiring pipeline.
- Collaboration Tools: Enable team collaboration, feedback sharing, and candidate rating.
- Customizable Templates: Create and customize job descriptions and interview templates.

Installation:
To run it locally, follow these steps:
1. Clone the repository: git clone https://github.com/Xtley001/SkillSync.git
2. Navigate to the project directory: cd SkillSync
3. Install dependencies: pip install -r requirements.txt
4. Set up environment variables.
5. Run the application: streamlit run app.py

Usage:
- Register and log in as an administrator or recruiter.
- Upload resumes and job descriptions.
- Use the keyword matching feature to analyze resumes against job requirements.
- View analytics, manage candidates, and collaborate with team members.
- Customize settings and templates based on your organization's needs.

Technologies Used:
- Python
- Streamlit
- Google Generative AI (for resume analysis)
- PDF2Image
- PyPDF2
- Pandas

Contributing:
Contributions are welcome! Here's how you can contribute:
1. Fork the repository.
2. Create a new branch (git checkout -b feature/fooBar).
3. Make your changes and commit (git commit -am 'Add some fooBar').
4. Push to the branch (git push origin feature/fooBar).
5. Create a new Pull Request.

License:
This project is licensed under the MIT License. See the LICENSE file for details.

Contact:
For support, feedback, or inquiries, please contact:
- Email: olubelachristley@gmail.com
- GitHub: github.com/Xtley001

