//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Web API Controllers" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Xomega.Framework;
using Xomega.Framework.Services;

namespace AdventureWorks.Services.Rest
{
    ///<summary>
    /// General sales order information.
    ///</summary>
    public partial class SalesOrderController : BaseController
    {
        private readonly ISalesOrderService svc;

        public SalesOrderController(ErrorList errorList, ErrorParser errorParser, ISalesOrderService service)
            : base(errorList, errorParser)
        {
            svc = service;
        }

        ///<summary>
        /// Reads the values of a Sales Order object by its key.
        ///</summary>
        [Route("sales-order/{_salesOrderId}")]
        [HttpGet]
        public async Task<ActionResult> ReadAsync([FromRoute] int _salesOrderId)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<SalesOrder_ReadOutput> output = await svc.ReadAsync(_salesOrderId);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Creates a new Sales Order object using the specified data.
        ///</summary>
        [Route("sales-order")]
        [HttpPost]
        public async Task<ActionResult> CreateAsync([FromBody] SalesOrder_CreateInput _data)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<SalesOrder_CreateOutput> output = await svc.CreateAsync(_data);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Updates existing Sales Order object using the specified data.
        ///</summary>
        [Route("sales-order/{_salesOrderId}")]
        [HttpPut]
        public async Task<ActionResult> UpdateAsync([FromRoute] int _salesOrderId, [FromBody] SalesOrder_UpdateInput_Data _data)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<SalesOrder_UpdateOutput> output = await svc.UpdateAsync(_salesOrderId, _data);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Deletes the specified Sales Order object.
        ///</summary>
        [Route("sales-order/{_salesOrderId}")]
        [HttpDelete]
        public async Task<ActionResult> DeleteAsync([FromRoute] int _salesOrderId)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output output = await svc.DeleteAsync(_salesOrderId);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Reads a list of Sales Order objects based on the specified criteria.
        ///</summary>
        [Route("sales-order")]
        [HttpGet]
        public async Task<ActionResult> ReadListAsync([FromQuery] SalesOrder_ReadListInput_Criteria _criteria)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<ICollection<SalesOrder_ReadListOutput>> output = await svc.ReadListAsync(_criteria);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Reads the values of a Sales Order Detail object by its key.
        ///</summary>
        [Route("sales-order/detail/{_salesOrderDetailId}")]
        [HttpGet]
        public async Task<ActionResult> Detail_ReadAsync([FromRoute] int _salesOrderDetailId)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<SalesOrderDetail_ReadOutput> output = await svc.Detail_ReadAsync(_salesOrderDetailId);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Creates a new Sales Order Detail object using the specified data.
        ///</summary>
        [Route("sales-order/{_salesOrderId}/detail")]
        [HttpPost]
        public async Task<ActionResult> Detail_CreateAsync([FromRoute] int _salesOrderId, [FromBody] SalesOrderDetail_CreateInput_Data _data)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<SalesOrderDetail_CreateOutput> output = await svc.Detail_CreateAsync(_salesOrderId, _data);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Updates existing Sales Order Detail object using the specified data.
        ///</summary>
        [Route("sales-order/detail/{_salesOrderDetailId}")]
        [HttpPut]
        public async Task<ActionResult> Detail_UpdateAsync([FromRoute] int _salesOrderDetailId, [FromBody] SalesOrderDetail_UpdateInput_Data _data)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output output = await svc.Detail_UpdateAsync(_salesOrderDetailId, _data);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Deletes the specified Sales Order Detail object.
        ///</summary>
        [Route("sales-order/detail/{_salesOrderDetailId}")]
        [HttpDelete]
        public async Task<ActionResult> Detail_DeleteAsync([FromRoute] int _salesOrderDetailId)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output output = await svc.Detail_DeleteAsync(_salesOrderDetailId);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }

        ///<summary>
        /// Reads a list of Sales Order Detail objects based on the specified criteria.
        ///</summary>
        [Route("sales-order/{_salesOrderId}/detail")]
        [HttpGet]
        public async Task<ActionResult> Detail_ReadListAsync([FromRoute] int _salesOrderId)
        {
            ActionResult response;
            try
            {
                if (ModelState.IsValid)
                {
                    Output<ICollection<SalesOrderDetail_ReadListOutput>> output = await svc.Detail_ReadListAsync(_salesOrderId);
                    response = StatusCode((int)output.HttpStatus, output);
                    return response;
                }
                else
                {
                    currentErrors.AddModelErrors(ModelState);
                }
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorsParser.FromException(ex));
            }
            response = StatusCode((int)currentErrors.HttpStatus, new Output(currentErrors));
            return response;
        }
    }
}