//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Service Implementations" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated
// unless they are placed between corresponding CUSTOM_CODE_START/CUSTOM_CODE_END lines.
//---------------------------------------------------------------------------------------------

using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Xomega.Framework.Services;
// CUSTOM_CODE_START: add namespaces for custom code below
// CUSTOM_CODE_END

namespace AdventureWorks.Services.Entities
{
    public partial class SalesPersonService : BaseService, ISalesPersonService
    {
        protected AdventureWorksEntities ctx;

        public SalesPersonService(IServiceProvider serviceProvider) : base(serviceProvider)
        {
            ctx = serviceProvider.GetService<AdventureWorksEntities>();
        }

        public virtual async Task<Output<ICollection<SalesPerson_ReadListOutput>>> ReadListAsync()
        {
            ICollection<SalesPerson_ReadListOutput> res = null;
            try
            {
                currentErrors.AbortIfHasErrors();

                // CUSTOM_CODE_START: add custom security checks for ReadList operation below
                // CUSTOM_CODE_END
                var src = from obj in ctx.SalesPerson select obj;

                // CUSTOM_CODE_START: add custom filter criteria to the source query for ReadList operation below
                // src = src.Where(o => o.FieldName == VALUE);
                // CUSTOM_CODE_END

                var qry = from obj in src
                          select new SalesPerson_ReadListOutput() {
                              BusinessEntityId = obj.BusinessEntityId,
                              TerritoryId = obj.TerritoryId,
                              // CUSTOM_CODE_START: set the Name output parameter of ReadList operation below
                              Name = obj.BusinessEntityObject.BusinessEntityObject.LastName + ", " +
                                     obj.BusinessEntityObject.BusinessEntityObject.FirstName, // CUSTOM_CODE_END
                              // CUSTOM_CODE_START: set the IsCurrent output parameter of ReadList operation below
                              IsCurrent = obj.BusinessEntityObject.CurrentFlag, // CUSTOM_CODE_END
                          };

                // CUSTOM_CODE_START: add custom filter criteria to the result query for ReadList operation below
                // qry = qry.Where(o => o.FieldName == VALUE);
                // CUSTOM_CODE_END

                currentErrors.AbortIfHasErrors();
                res = await qry.ToListAsync();
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorParser.FromException(ex));
            }
            return await Task.FromResult(new Output<ICollection<SalesPerson_ReadListOutput>>(currentErrors, res));
        }
    }
}