//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Service Implementations" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated
// unless they are placed between corresponding CUSTOM_CODE_START/CUSTOM_CODE_END lines.
//
// This file can be DELETED DURING REGENERATION IF NO LONGER NEEDED, e.g. if it gets renamed.
// To prevent this and preserve manual custom changes please remove the line above.
//---------------------------------------------------------------------------------------------

using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Xomega.Framework.Services;
// CUSTOM_CODE_START: add namespaces for custom code below
// CUSTOM_CODE_END

namespace AdventureWorks.Services.Entities
{
    public partial class PersonCreditCardService : BaseService, IPersonCreditCardService
    {
        protected AdventureWorksEntities ctx;

        public PersonCreditCardService(IServiceProvider serviceProvider) : base(serviceProvider)
        {
            ctx = serviceProvider.GetService<AdventureWorksEntities>();
        }

        public virtual async Task<Output<ICollection<PersonCreditCard_ReadListOutput>>> ReadListAsync(int _businessEntityId)
        {
            ICollection<PersonCreditCard_ReadListOutput> res = null;
            try
            {
                currentErrors.AbortIfHasErrors();

                // CUSTOM_CODE_START: add custom security checks for ReadList operation below
                // CUSTOM_CODE_END
                var src = from obj in ctx.PersonCreditCard select obj;

                // Source filter
                src = AddClause(src, "BusinessEntityId", o => o.BusinessEntityId, _businessEntityId);

                // CUSTOM_CODE_START: add custom filter criteria to the source query for ReadList operation below
                // src = src.Where(o => o.FieldName == VALUE);
                // CUSTOM_CODE_END

                var qry = from obj in src
                          select new PersonCreditCard_ReadListOutput() {
                              CreditCardId = obj.CreditCardId,
                              // CUSTOM_CODE_START: set the CreditCardName output parameter of ReadList operation below
                              CreditCardName = obj.CreditCardObject.CardType + "-*" +
                                               obj.CreditCardObject.CardNumber.Substring(
                                                   obj.CreditCardObject.CardNumber.Length - 4), // CUSTOM_CODE_END
                              // CUSTOM_CODE_START: set the PersonName output parameter of ReadList operation below
                              PersonName = obj.BusinessEntityObject.LastName + ", " +
                                           obj.BusinessEntityObject.FirstName, // CUSTOM_CODE_END
                              // CUSTOM_CODE_START: set the CardType output parameter of ReadList operation below
                              CardType = obj.CreditCardObject.CardType, // CUSTOM_CODE_END
                              // CUSTOM_CODE_START: set the CardNumber output parameter of ReadList operation below
                              CardNumber = obj.CreditCardObject.CardNumber, // CUSTOM_CODE_END
                              // CUSTOM_CODE_START: set the ExpMonth output parameter of ReadList operation below
                              ExpMonth = obj.CreditCardObject.ExpMonth, // CUSTOM_CODE_END
                              // CUSTOM_CODE_START: set the ExpYear output parameter of ReadList operation below
                              ExpYear = obj.CreditCardObject.ExpYear, // CUSTOM_CODE_END
                          };

                // CUSTOM_CODE_START: add custom filter criteria to the result query for ReadList operation below
                // qry = qry.Where(o => o.FieldName == VALUE);
                // CUSTOM_CODE_END

                currentErrors.AbortIfHasErrors();
                res = await qry.ToListAsync();
            }
            catch (Exception ex)
            {
                currentErrors.MergeWith(errorParser.FromException(ex));
            }
            return await Task.FromResult(new Output<ICollection<PersonCreditCard_ReadListOutput>>(currentErrors, res));
        }
    }
}