//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Service Contracts" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace AdventureWorks.Services
{
    #region CreditCardInfo structure

    [DataContract]
    public class CreditCardInfo
    {
        
        [DataMember]
        public int CreditCardId { get; set; }
        
        ///<summary>
        /// Credit card number.
        ///</summary>
        [DataMember]
        public string CardNumber { get; set; }
        
        [DataMember]
        public string Expiration { get; set; }
    }
    #endregion

    #region CustomerLookup structure

    [DataContract]
    public class CustomerLookup
    {
        
        [DataMember]
        public string StoreName { get; set; }
        
        [DataMember]
        public string PersonName { get; set; }
    }
    #endregion

    #region CustomerInfo structure

    [DataContract]
    public class CustomerInfo
    {
        
        [DataMember]
        public int CustomerId { get; set; }
        
        ///<summary>
        /// Foreign key to Store.BusinessEntityID
        ///</summary>
        [DataMember]
        public int? StoreId { get; set; }
        
        [DataMember]
        public string StoreName { get; set; }
        
        ///<summary>
        /// Foreign key to Person.BusinessEntityID
        ///</summary>
        [DataMember]
        public int? PersonId { get; set; }
        
        [DataMember]
        public string PersonName { get; set; }
        
        ///<summary>
        /// Unique number identifying the customer assigned by the accounting system.
        ///</summary>
        [DataMember]
        public string AccountNumber { get; set; }
        
        ///<summary>
        /// ID of the territory in which the customer is located. Foreign key to SalesTerritory.SalesTerritoryID.
        ///</summary>
        [DataMember]
        public int? TerritoryId { get; set; }
        
        [DataMember]
        public AddressKey BillingAddress { get; set; }
        
        [DataMember]
        public AddressKey ShippingAddress { get; set; }
    }
    #endregion

    #region CustomerUpdate structure

    [DataContract]
    public class CustomerUpdate
    {
        
        [DataMember]
        public int CustomerId { get; set; }
        
        [DataMember]
        public AddressKey BillingAddress { get; set; }
        
        [DataMember]
        public AddressKey ShippingAddress { get; set; }
    }
    #endregion

    #region PaymentInfo structure

    [DataContract]
    public class PaymentInfo
    {
        
        ///<summary>
        /// Sales subtotal. Computed as SUM(SalesOrderDetail.LineTotal)for the appropriate SalesOrderID.
        ///</summary>
        [DataMember]
        public decimal SubTotal { get; set; }
        
        ///<summary>
        /// Shipping method. Foreign key to ShipMethod.ShipMethodID.
        ///</summary>
        [DataMember]
        public int ShipMethodId { get; set; }
        
        ///<summary>
        /// Tax amount.
        ///</summary>
        [DataMember]
        public decimal TaxAmt { get; set; }
        
        ///<summary>
        /// Shipping cost.
        ///</summary>
        [DataMember]
        public decimal Freight { get; set; }
        
        ///<summary>
        /// Total due from customer. Computed as Subtotal + TaxAmt + Freight.
        ///</summary>
        [DataMember]
        public decimal TotalDue { get; set; }
        
        ///<summary>
        /// Date the order is due to the customer.
        ///</summary>
        [DataMember]
        public DateTime DueDate { get; set; }
        
        [DataMember]
        public string CurrencyRate { get; set; }
        
        [DataMember]
        public PaymentInfo_CreditCard CreditCard { get; set; }
    }
    #endregion

    #region PaymentInfo_CreditCard structure

    ///<summary>
    /// Structure of parameter CreditCard of structure PaymentInfo.
    ///</summary>
    [DataContract]
    public class PaymentInfo_CreditCard
    {
        
        ///<summary>
        /// Credit card identification number. Foreign key to CreditCard.CreditCardID.
        ///</summary>
        [DataMember]
        public int CreditCardId { get; set; }
        
        ///<summary>
        /// Approval code provided by the credit card company.
        ///</summary>
        [DataMember]
        public string CreditCardApprovalCode { get; set; }
    }
    #endregion

    #region PaymentUpdate structure

    [DataContract]
    public class PaymentUpdate
    {
        
        ///<summary>
        /// Shipping method. Foreign key to ShipMethod.ShipMethodID.
        ///</summary>
        [DataMember]
        public int ShipMethodId { get; set; }
        
        ///<summary>
        /// Date the order is due to the customer.
        ///</summary>
        [DataMember]
        public DateTime DueDate { get; set; }
        
        [DataMember]
        public PaymentUpdate_CreditCard CreditCard { get; set; }
    }
    #endregion

    #region PaymentUpdate_CreditCard structure

    ///<summary>
    /// Structure of parameter CreditCard of structure PaymentUpdate.
    ///</summary>
    [DataContract]
    public class PaymentUpdate_CreditCard
    {
        
        ///<summary>
        /// Credit card identification number. Foreign key to CreditCard.CreditCardID.
        ///</summary>
        [DataMember]
        public int CreditCardId { get; set; }
        
        ///<summary>
        /// Approval code provided by the credit card company.
        ///</summary>
        [DataMember]
        public string CreditCardApprovalCode { get; set; }
    }
    #endregion

    #region SalesInfo structure

    [DataContract]
    public class SalesInfo
    {
        
        ///<summary>
        /// Territory in which the sale was made. Foreign key to SalesTerritory.SalesTerritoryID.
        ///</summary>
        [DataMember]
        public int? TerritoryId { get; set; }
        
        ///<summary>
        /// Sales person who created the sales order. Foreign key to SalesPerson.BusinessEntityID.
        ///</summary>
        [DataMember]
        public int? SalesPersonId { get; set; }
        
        [DataMember]
        public ICollection<int> SalesReason { get; set; }
    }
    #endregion

}