//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Service Contracts" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

using AdventureWorks.Enumerations;
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Threading.Tasks;
using Xomega.Framework.Services;

namespace AdventureWorks.Services
{
    #region ISalesOrderService interface

    ///<summary>
    /// General sales order information.
    ///</summary>
    [ServiceContract]
    public interface ISalesOrderService
    {

        ///<summary>
        /// Reads the values of a Sales Order object by its key.
        ///</summary>
        [OperationContract]
        Task<Output<SalesOrder_ReadOutput>> ReadAsync(int _salesOrderId);

        ///<summary>
        /// Creates a new Sales Order object using the specified data.
        ///</summary>
        [OperationContract]
        Task<Output<SalesOrder_CreateOutput>> CreateAsync(SalesOrder_CreateInput _data);

        ///<summary>
        /// Updates existing Sales Order object using the specified data.
        ///</summary>
        [OperationContract]
        Task<Output<SalesOrder_UpdateOutput>> UpdateAsync(int _salesOrderId, SalesOrder_UpdateInput_Data _data);

        ///<summary>
        /// Deletes the specified Sales Order object.
        ///</summary>
        [OperationContract]
        Task<Output> DeleteAsync(int _salesOrderId);

        ///<summary>
        /// Reads a list of Sales Order objects based on the specified criteria.
        ///</summary>
        [OperationContract]
        Task<Output<ICollection<SalesOrder_ReadListOutput>>> ReadListAsync(SalesOrder_ReadListInput_Criteria _criteria);

        ///<summary>
        /// Reads the values of a Sales Order Detail object by its key.
        ///</summary>
        [OperationContract]
        Task<Output<SalesOrderDetail_ReadOutput>> Detail_ReadAsync(int _salesOrderDetailId);

        ///<summary>
        /// Creates a new Sales Order Detail object using the specified data.
        ///</summary>
        [OperationContract]
        Task<Output<SalesOrderDetail_CreateOutput>> Detail_CreateAsync(int _salesOrderId, SalesOrderDetail_CreateInput_Data _data);

        ///<summary>
        /// Updates existing Sales Order Detail object using the specified data.
        ///</summary>
        [OperationContract]
        Task<Output> Detail_UpdateAsync(int _salesOrderDetailId, SalesOrderDetail_UpdateInput_Data _data);

        ///<summary>
        /// Deletes the specified Sales Order Detail object.
        ///</summary>
        [OperationContract]
        Task<Output> Detail_DeleteAsync(int _salesOrderDetailId);

        ///<summary>
        /// Reads a list of Sales Order Detail objects based on the specified criteria.
        ///</summary>
        [OperationContract]
        Task<Output<ICollection<SalesOrderDetail_ReadListOutput>>> Detail_ReadListAsync(int _salesOrderId);

    }
    #endregion

    #region SalesOrder_ReadOutput structure

    ///<summary>
    /// The output structure of operation ISalesOrderService.ReadAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_ReadOutput
    {
        
        ///<summary>
        /// Unique sales order identification number.
        ///</summary>
        [DataMember]
        public string SalesOrderNumber { get; set; }
        
        ///<summary>
        /// Dates the sales order was created.
        ///</summary>
        [DataMember]
        public DateTime OrderDate { get; set; }
        
        ///<summary>
        /// Order current status.
        ///</summary>
        [DataMember]
        public byte Status { get; set; }
        
        ///<summary>
        /// 0 = Order placed by sales person. 1 = Order placed online by customer.
        ///</summary>
        [DataMember]
        public bool OnlineOrderFlag { get; set; }
        
        ///<summary>
        /// Customer purchase order number reference. 
        ///</summary>
        [DataMember]
        public string PurchaseOrderNumber { get; set; }
        
        ///<summary>
        /// Financial accounting number reference.
        ///</summary>
        [DataMember]
        public string AccountNumber { get; set; }
        
        [DataMember]
        public CustomerInfo Customer { get; set; }
        
        ///<summary>
        /// Date the order was shipped to the customer.
        ///</summary>
        [DataMember]
        public DateTime? ShipDate { get; set; }
        
        [DataMember]
        public PaymentInfo Payment { get; set; }
        
        [DataMember]
        public SalesInfo Sales { get; set; }
        
        ///<summary>
        /// Sales representative comments.
        ///</summary>
        [DataMember]
        public string Comment { get; set; }
        
        ///<summary>
        /// Incremental number to track changes to the sales order over time.
        ///</summary>
        [DataMember]
        public byte RevisionNumber { get; set; }
        
        ///<summary>
        /// Date and time the record was last updated.
        ///</summary>
        [DataMember]
        public DateTime ModifiedDate { get; set; }
    }
    #endregion

    #region SalesOrder_CreateInput structure

    ///<summary>
    /// The input structure of operation ISalesOrderService.CreateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_CreateInput
    {
        
        ///<summary>
        /// Order current status.
        ///</summary>
        [DataMember]
        [XRequired]
        [XLookupValue(SalesOrderStatus.EnumName)]
        public byte Status { get; set; }
        
        ///<summary>
        /// 0 = Order placed by sales person. 1 = Order placed online by customer.
        ///</summary>
        [DataMember]
        [XRequired]
        public bool OnlineOrderFlag { get; set; }
        
        ///<summary>
        /// Customer purchase order number reference. 
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        public string PurchaseOrderNumber { get; set; }
        
        ///<summary>
        /// Financial accounting number reference.
        ///</summary>
        [DataMember]
        [XMaxLength(15)]
        public string AccountNumber { get; set; }
        
        [DataMember]
        public CustomerUpdate Customer { get; set; }
        
        ///<summary>
        /// Date the order was shipped to the customer.
        ///</summary>
        [DataMember]
        public DateTime? ShipDate { get; set; }
        
        [DataMember]
        public PaymentUpdate Payment { get; set; }
        
        [DataMember]
        public SalesInfo Sales { get; set; }
        
        ///<summary>
        /// Sales representative comments.
        ///</summary>
        [DataMember]
        [XMaxLength(128)]
        public string Comment { get; set; }
    }
    #endregion

    #region SalesOrder_CreateOutput structure

    ///<summary>
    /// The output structure of operation ISalesOrderService.CreateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_CreateOutput
    {
        
        [DataMember]
        public int SalesOrderId { get; set; }
        
        ///<summary>
        /// Unique sales order identification number.
        ///</summary>
        [DataMember]
        public string SalesOrderNumber { get; set; }
        
        ///<summary>
        /// Dates the sales order was created.
        ///</summary>
        [DataMember]
        public DateTime OrderDate { get; set; }
        
        ///<summary>
        /// Incremental number to track changes to the sales order over time.
        ///</summary>
        [DataMember]
        public byte RevisionNumber { get; set; }
        
        ///<summary>
        /// Date and time the record was last updated.
        ///</summary>
        [DataMember]
        public DateTime ModifiedDate { get; set; }
    }
    #endregion

    #region SalesOrder_UpdateInput_Data structure

    ///<summary>
    /// Structure of parameter Data of the input structure of operation ISalesOrderService.UpdateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_UpdateInput_Data
    {
        
        ///<summary>
        /// Order current status.
        ///</summary>
        [DataMember]
        [XRequired]
        [XLookupValue(SalesOrderStatus.EnumName)]
        public byte Status { get; set; }
        
        ///<summary>
        /// 0 = Order placed by sales person. 1 = Order placed online by customer.
        ///</summary>
        [DataMember]
        [XRequired]
        public bool OnlineOrderFlag { get; set; }
        
        ///<summary>
        /// Customer purchase order number reference. 
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        public string PurchaseOrderNumber { get; set; }
        
        ///<summary>
        /// Financial accounting number reference.
        ///</summary>
        [DataMember]
        [XMaxLength(15)]
        public string AccountNumber { get; set; }
        
        [DataMember]
        public CustomerUpdate Customer { get; set; }
        
        ///<summary>
        /// Date the order was shipped to the customer.
        ///</summary>
        [DataMember]
        public DateTime? ShipDate { get; set; }
        
        [DataMember]
        public PaymentUpdate Payment { get; set; }
        
        [DataMember]
        public SalesInfo Sales { get; set; }
        
        ///<summary>
        /// Sales representative comments.
        ///</summary>
        [DataMember]
        [XMaxLength(128)]
        public string Comment { get; set; }
    }
    #endregion

    #region SalesOrder_UpdateOutput structure

    ///<summary>
    /// The output structure of operation ISalesOrderService.UpdateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_UpdateOutput
    {
        
        ///<summary>
        /// Incremental number to track changes to the sales order over time.
        ///</summary>
        [DataMember]
        public byte RevisionNumber { get; set; }
        
        ///<summary>
        /// Date and time the record was last updated.
        ///</summary>
        [DataMember]
        public DateTime ModifiedDate { get; set; }
    }
    #endregion

    #region SalesOrder_ReadListInput_Criteria structure

    ///<summary>
    /// Structure of parameter Criteria of the input structure of operation ISalesOrderService.ReadListAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_ReadListInput_Criteria
    {
        
        ///<summary>
        /// Comparison operator for the corresponding Sales Order Number criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string SalesOrderNumberOperator { get; set; }
        
        ///<summary>
        /// Unique sales order identification number.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        public string SalesOrderNumber { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Status criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string StatusOperator { get; set; }
        
        ///<summary>
        /// Order current status.
        ///</summary>
        [DataMember]
        [XLookupValue(SalesOrderStatus.EnumName)]
        public ICollection<byte> Status { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Order Date criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string OrderDateOperator { get; set; }
        
        ///<summary>
        /// Dates the sales order was created.
        ///</summary>
        [DataMember]
        public DateTime? OrderDate { get; set; }
        
        ///<summary>
        /// End of range for the corresponding Order Date criteria for the BETWEEN operator.
        ///</summary>
        [DataMember]
        public DateTime? OrderDate2 { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Due Date criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string DueDateOperator { get; set; }
        
        ///<summary>
        /// Date the order is due to the customer.
        ///</summary>
        [DataMember]
        public DateTime? DueDate { get; set; }
        
        ///<summary>
        /// End of range for the corresponding Due Date criteria for the BETWEEN operator.
        ///</summary>
        [DataMember]
        public DateTime? DueDate2 { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Total Due criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string TotalDueOperator { get; set; }
        
        ///<summary>
        /// Total due from customer. Computed as Subtotal + TaxAmt + Freight.
        ///</summary>
        [DataMember]
        public decimal? TotalDue { get; set; }
        
        ///<summary>
        /// End of range for the corresponding Total Due criteria for the BETWEEN operator.
        ///</summary>
        [DataMember]
        public decimal? TotalDue2 { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Customer store criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string CustomerStoreOperator { get; set; }
        
        [DataMember]
        public string CustomerStore { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Customer name criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string CustomerNameOperator { get; set; }
        
        [DataMember]
        public string CustomerName { get; set; }
        
        [DataMember]
        [XMaxLength(50)]
        [XLookupValue(SalesTerritoryGroup.EnumName)]
        public string GlobalRegion { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Territory Id criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string TerritoryIdOperator { get; set; }
        
        ///<summary>
        /// Territory in which the sale was made. Foreign key to SalesTerritory.SalesTerritoryID.
        ///</summary>
        [DataMember]
        [XLookupValue(SalesTerritory.EnumName)]
        public int? TerritoryId { get; set; }
        
        ///<summary>
        /// Comparison operator for the corresponding Sales Person Id criteria.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string SalesPersonIdOperator { get; set; }
        
        ///<summary>
        /// Sales person who created the sales order. Foreign key to SalesPerson.BusinessEntityID.
        ///</summary>
        [DataMember]
        [XLookupValue(SalesPerson.EnumName)]
        public ICollection<int> SalesPersonId { get; set; }
    }
    #endregion

    #region SalesOrder_ReadListOutput structure

    ///<summary>
    /// The output structure of operation ISalesOrderService.ReadListAsync.
    ///</summary>
    [DataContract]
    public class SalesOrder_ReadListOutput
    {
        
        [DataMember]
        public int SalesOrderId { get; set; }
        
        ///<summary>
        /// Unique sales order identification number.
        ///</summary>
        [DataMember]
        public string SalesOrderNumber { get; set; }
        
        ///<summary>
        /// Order current status.
        ///</summary>
        [DataMember]
        public byte Status { get; set; }
        
        ///<summary>
        /// Dates the sales order was created.
        ///</summary>
        [DataMember]
        public DateTime OrderDate { get; set; }
        
        ///<summary>
        /// Date the order was shipped to the customer.
        ///</summary>
        [DataMember]
        public DateTime? ShipDate { get; set; }
        
        ///<summary>
        /// Date the order is due to the customer.
        ///</summary>
        [DataMember]
        public DateTime DueDate { get; set; }
        
        ///<summary>
        /// Total due from customer. Computed as Subtotal + TaxAmt + Freight.
        ///</summary>
        [DataMember]
        public decimal TotalDue { get; set; }
        
        ///<summary>
        /// 0 = Order placed by sales person. 1 = Order placed online by customer.
        ///</summary>
        [DataMember]
        public bool OnlineOrderFlag { get; set; }
        
        [DataMember]
        public string CustomerStore { get; set; }
        
        [DataMember]
        public string CustomerName { get; set; }
        
        ///<summary>
        /// Sales person who created the sales order. Foreign key to SalesPerson.BusinessEntityID.
        ///</summary>
        [DataMember]
        public int? SalesPersonId { get; set; }
        
        ///<summary>
        /// Territory in which the sale was made. Foreign key to SalesTerritory.SalesTerritoryID.
        ///</summary>
        [DataMember]
        public int? TerritoryId { get; set; }
    }
    #endregion

    #region SalesOrderDetail_ReadOutput structure

    ///<summary>
    /// The output structure of operation IDetailService.Detail_ReadAsync.
    ///</summary>
    [DataContract]
    public class SalesOrderDetail_ReadOutput
    {
        
        [DataMember]
        public int SalesOrderId { get; set; }
        
        [DataMember]
        public int? Subcategory { get; set; }
        
        [DataMember]
        public int ProductId { get; set; }
        
        ///<summary>
        /// Quantity ordered per product.
        ///</summary>
        [DataMember]
        public short OrderQty { get; set; }
        
        [DataMember]
        public int SpecialOfferId { get; set; }
        
        ///<summary>
        /// Selling price of a single product.
        ///</summary>
        [DataMember]
        public decimal UnitPrice { get; set; }
        
        ///<summary>
        /// Discount amount.
        ///</summary>
        [DataMember]
        public decimal UnitPriceDiscount { get; set; }
        
        ///<summary>
        /// Per product subtotal. Computed as UnitPrice * (1 - UnitPriceDiscount) * OrderQty.
        ///</summary>
        [DataMember]
        public decimal LineTotal { get; set; }
        
        ///<summary>
        /// Shipment tracking number supplied by the shipper.
        ///</summary>
        [DataMember]
        public string CarrierTrackingNumber { get; set; }
    }
    #endregion

    #region SalesOrderDetail_CreateInput_Data structure

    ///<summary>
    /// Structure of parameter Data of the input structure of operation IDetailService.Detail_CreateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrderDetail_CreateInput_Data
    {
        
        [DataMember]
        [XRequired]
        [XLookupValue(Product.EnumName)]
        public int ProductId { get; set; }
        
        ///<summary>
        /// Quantity ordered per product.
        ///</summary>
        [DataMember]
        [XRequired]
        public short OrderQty { get; set; }
        
        [DataMember]
        [XRequired]
        [XLookupValue(SpecialOffer.EnumName)]
        public int SpecialOfferId { get; set; }
        
        ///<summary>
        /// Shipment tracking number supplied by the shipper.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        public string CarrierTrackingNumber { get; set; }
    }
    #endregion

    #region SalesOrderDetail_CreateOutput structure

    ///<summary>
    /// The output structure of operation IDetailService.Detail_CreateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrderDetail_CreateOutput
    {
        
        [DataMember]
        public int SalesOrderDetailId { get; set; }
    }
    #endregion

    #region SalesOrderDetail_UpdateInput_Data structure

    ///<summary>
    /// Structure of parameter Data of the input structure of operation IDetailService.Detail_UpdateAsync.
    ///</summary>
    [DataContract]
    public class SalesOrderDetail_UpdateInput_Data
    {
        
        [DataMember]
        [XRequired]
        [XLookupValue(Product.EnumName)]
        public int ProductId { get; set; }
        
        ///<summary>
        /// Quantity ordered per product.
        ///</summary>
        [DataMember]
        [XRequired]
        public short OrderQty { get; set; }
        
        [DataMember]
        [XRequired]
        [XLookupValue(SpecialOffer.EnumName)]
        public int SpecialOfferId { get; set; }
        
        ///<summary>
        /// Shipment tracking number supplied by the shipper.
        ///</summary>
        [DataMember]
        [XMaxLength(25)]
        public string CarrierTrackingNumber { get; set; }
    }
    #endregion

    #region SalesOrderDetail_ReadListOutput structure

    ///<summary>
    /// The output structure of operation IDetailService.Detail_ReadListAsync.
    ///</summary>
    [DataContract]
    public class SalesOrderDetail_ReadListOutput
    {
        
        [DataMember]
        public int SalesOrderDetailId { get; set; }
        
        [DataMember]
        public int ProductId { get; set; }
        
        ///<summary>
        /// Quantity ordered per product.
        ///</summary>
        [DataMember]
        public short OrderQty { get; set; }
        
        ///<summary>
        /// Selling price of a single product.
        ///</summary>
        [DataMember]
        public decimal UnitPrice { get; set; }
        
        ///<summary>
        /// Discount amount.
        ///</summary>
        [DataMember]
        public decimal UnitPriceDiscount { get; set; }
        
        [DataMember]
        public int SpecialOfferId { get; set; }
        
        ///<summary>
        /// Per product subtotal. Computed as UnitPrice * (1 - UnitPriceDiscount) * OrderQty.
        ///</summary>
        [DataMember]
        public decimal LineTotal { get; set; }
        
        ///<summary>
        /// Shipment tracking number supplied by the shipper.
        ///</summary>
        [DataMember]
        public string CarrierTrackingNumber { get; set; }
    }
    #endregion

}