//---------------------------------------------------------------------------------------------
// This file was AUTO-GENERATED by "Service Contracts" Xomega.Net generator.
//
// Manual CHANGES to this file WILL BE LOST when the code is regenerated.
//---------------------------------------------------------------------------------------------

using AdventureWorks.Enumerations;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Threading.Tasks;
using Xomega.Framework.Services;

namespace AdventureWorks.Services
{
    #region ICustomerService interface

    ///<summary>
    /// Current customer information. Also see the Person and Store tables.
    ///</summary>
    [ServiceContract]
    public interface ICustomerService
    {

        ///<summary>
        /// Reads a list of Customer objects based on the specified criteria.
        ///</summary>
        [OperationContract]
        Task<Output<ICollection<Customer_ReadListOutput>>> ReadListAsync(Customer_ReadListInput_Criteria _criteria);

    }
    #endregion

    #region Customer_ReadListInput_Criteria structure

    ///<summary>
    /// Structure of parameter Criteria of the input structure of operation ICustomerService.ReadListAsync.
    ///</summary>
    [DataContract]
    public class Customer_ReadListInput_Criteria
    {
        
        ///<summary>
        /// ID of the territory in which the customer is located. Foreign key to SalesTerritory.SalesTerritoryID.
        ///</summary>
        [DataMember]
        [XLookupValue(SalesTerritory.EnumName)]
        public int? TerritoryId { get; set; }
        
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string PersonNameOperator { get; set; }
        
        [DataMember]
        public string PersonName { get; set; }
        
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string StoreNameOperator { get; set; }
        
        [DataMember]
        public string StoreName { get; set; }
        
        [DataMember]
        [XMaxLength(25)]
        [XLookupValue(Operators.EnumName)]
        public string AccountNumberOperator { get; set; }
        
        ///<summary>
        /// Unique number identifying the customer assigned by the accounting system.
        ///</summary>
        [DataMember]
        [XMaxLength(10)]
        public string AccountNumber { get; set; }
    }
    #endregion

    #region Customer_ReadListOutput structure

    ///<summary>
    /// The output structure of operation ICustomerService.ReadListAsync.
    ///</summary>
    [DataContract]
    public class Customer_ReadListOutput
    {
        
        [DataMember]
        public int CustomerId { get; set; }
        
        ///<summary>
        /// Foreign key to Store.BusinessEntityID
        ///</summary>
        [DataMember]
        public int? StoreId { get; set; }
        
        [DataMember]
        public string StoreName { get; set; }
        
        ///<summary>
        /// Foreign key to Person.BusinessEntityID
        ///</summary>
        [DataMember]
        public int? PersonId { get; set; }
        
        [DataMember]
        public string PersonName { get; set; }
        
        ///<summary>
        /// Unique number identifying the customer assigned by the accounting system.
        ///</summary>
        [DataMember]
        public string AccountNumber { get; set; }
        
        ///<summary>
        /// ID of the territory in which the customer is located. Foreign key to SalesTerritory.SalesTerritoryID.
        ///</summary>
        [DataMember]
        public int? TerritoryId { get; set; }
    }
    #endregion

}